/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.content;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.kie.eclipse.navigator.view.content.ContainerNode;
import org.kie.eclipse.navigator.view.content.IContentNode;
import org.kie.eclipse.navigator.view.content.RepositoryNode;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieResourceHandler;

public class ProjectNode
extends ContainerNode<RepositoryNode>
implements IResourceChangeListener {
    protected ProjectNode(RepositoryNode parent, IKieProjectHandler project) {
        super(parent, (IKieResourceHandler)project);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    protected List<? extends IContentNode<?>> createChildren() {
        return null;
    }

    @Override
    public Object resolveContent() {
        Object resource = this.getHandler().load();
        if (resource == null) {
            resource = super.resolveContent();
        }
        if (resource instanceof IProject) {
            try {
                ((IProject)resource).setSessionProperty(IKieResourceHandler.RESOURCE_KEY, (Object)this);
            }
            catch (Exception exception) {}
        }
        return resource;
    }

    @Override
    public void dispose() {
        try {
            IProject project = (IProject)this.getHandler().getResource();
            project.setSessionProperty(IKieResourceHandler.RESOURCE_KEY, null);
        }
        catch (Exception exception) {}
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource instanceof IProject) {
                            switch (delta.getKind()) {
                                case 2: {
                                    final ProjectNode container = ProjectNode.this;
                                    final IKieProjectHandler handler = (IKieProjectHandler)ProjectNode.this.getHandler();
                                    if (resource != handler.getResource()) break;
                                    handler.setResource(null);
                                    File directory = handler.getDirectory();
                                    if (directory == null || directory.exists()) break;
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                handler.getDelegate().deleteProject(handler);
                                                container.getParent().clearChildren();
                                                ProjectNode.this.refresh();
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

