/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.KieComponentFactory;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.constraint.XpathConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.RuleComponent;
import org.drools.core.time.TemporalDependencyMatrix;

public class BuildContext {
    private LeftTupleSource tupleSource;
    private ObjectSource objectSource;
    private LinkedList<Pattern> objectType;
    private int currentPatternOffset;
    private InternalKnowledgeBase kBase;
    private RuleImpl rule;
    private GroupElement subRule;
    private Stack<RuleComponent> ruleComponent;
    private InternalWorkingMemory[] workingMemories;
    private LinkedList<RuleConditionElement> buildstack;
    private List<BetaNodeFieldConstraint> betaconstraints;
    private List<AlphaNodeFieldConstraint> alphaConstraints;
    private List<XpathConstraint> xpathConstraints;
    private EntryPointId currentEntryPoint;
    private boolean tupleMemoryEnabled;
    private boolean objectTypeNodeMemoryEnabled;
    private boolean query;
    private List<PathEndNode> pathEndNodes = new ArrayList<PathEndNode>();
    private List<BaseNode> nodes;
    private RuleBasePartitionId partitionId;
    private TemporalDependencyMatrix temporal;
    private ObjectTypeNode rootObjectTypeNode;
    private Pattern[] lastBuiltPatterns;
    private boolean emptyForAllBetaConstraints;
    private boolean attachPQN;
    private boolean terminated;
    private final KieComponentFactory componentFactory;
    private String consequenceName;

    public BuildContext(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
        this.workingMemories = null;
        this.objectType = null;
        this.buildstack = null;
        this.tupleSource = null;
        this.objectSource = null;
        this.currentPatternOffset = 0;
        this.tupleMemoryEnabled = true;
        this.objectTypeNodeMemoryEnabled = true;
        this.currentEntryPoint = EntryPointId.DEFAULT;
        this.nodes = new LinkedList<BaseNode>();
        this.partitionId = null;
        this.ruleComponent = new Stack();
        this.attachPQN = true;
        this.componentFactory = kBase.getConfiguration().getComponentFactory();
        this.emptyForAllBetaConstraints = false;
    }

    public boolean isEmptyForAllBetaConstraints() {
        return this.emptyForAllBetaConstraints;
    }

    void setEmptyForAllBetaConstraints() {
        this.emptyForAllBetaConstraints = true;
    }

    int getCurrentPatternOffset() {
        return this.currentPatternOffset;
    }

    void setCurrentPatternOffset(int currentPatternIndex) {
        this.currentPatternOffset = currentPatternIndex;
        this.syncObjectTypesWithPatternOffset();
    }

    private void syncObjectTypesWithPatternOffset() {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        while (this.objectType.size() > this.currentPatternOffset) {
            this.objectType.removeLast();
        }
    }

    public ObjectSource getObjectSource() {
        return this.objectSource;
    }

    public void setObjectSource(ObjectSource objectSource) {
        this.objectSource = objectSource;
    }

    public LinkedList<Pattern> getObjectType() {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        return this.objectType;
    }

    public void setObjectType(LinkedList<Pattern> objectType) {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        this.objectType = objectType;
    }

    public LeftTupleSource getTupleSource() {
        return this.tupleSource;
    }

    public void setTupleSource(LeftTupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    void incrementCurrentPatternOffset() {
        ++this.currentPatternOffset;
    }

    void decrementCurrentPatternOffset() {
        --this.currentPatternOffset;
        this.syncObjectTypesWithPatternOffset();
    }

    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    public InternalWorkingMemory[] getWorkingMemories() {
        if (this.workingMemories == null) {
            this.workingMemories = this.kBase.getWorkingMemories();
        }
        return this.workingMemories;
    }

    public int getNextId() {
        return this.kBase.getReteooBuilder().getIdGenerator().getNextId();
    }

    public int getNextId(String topic) {
        return this.kBase.getReteooBuilder().getIdGenerator().getNextId(topic);
    }

    public void releaseId(NetworkNode node) {
        this.kBase.getReteooBuilder().getIdGenerator().releaseId(this.rule, node);
    }

    public void push(RuleConditionElement rce) {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        this.buildstack.addLast(rce);
    }

    public RuleConditionElement pop() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return this.buildstack.removeLast();
    }

    public RuleConditionElement peek() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return this.buildstack.getLast();
    }

    ListIterator<RuleConditionElement> stackIterator() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return this.buildstack.listIterator(this.buildstack.size());
    }

    public List<BetaNodeFieldConstraint> getBetaconstraints() {
        return this.betaconstraints;
    }

    public void setBetaconstraints(List<BetaNodeFieldConstraint> betaconstraints) {
        this.betaconstraints = betaconstraints;
    }

    public List<AlphaNodeFieldConstraint> getAlphaConstraints() {
        return this.alphaConstraints;
    }

    void setAlphaConstraints(List<AlphaNodeFieldConstraint> alphaConstraints) {
        this.alphaConstraints = alphaConstraints;
    }

    List<XpathConstraint> getXpathConstraints() {
        return this.xpathConstraints;
    }

    List<PathEndNode> getPathEndNodes() {
        return this.pathEndNodes;
    }

    public void addPathEndNode(PathEndNode node) {
        this.pathEndNodes.add(node);
    }

    void setXpathConstraints(List<XpathConstraint> xpathConstraints) {
        this.xpathConstraints = xpathConstraints;
    }

    public boolean isTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setTupleMemoryEnabled(boolean hasLeftMemory) {
        this.tupleMemoryEnabled = hasLeftMemory;
    }

    public boolean isObjectTypeNodeMemoryEnabled() {
        return this.objectTypeNodeMemoryEnabled;
    }

    public void setObjectTypeNodeMemoryEnabled(boolean hasObjectTypeMemory) {
        this.objectTypeNodeMemoryEnabled = hasObjectTypeMemory;
    }

    public boolean isQuery() {
        return this.query;
    }

    public EntryPointId getCurrentEntryPoint() {
        return this.currentEntryPoint;
    }

    public void setCurrentEntryPoint(EntryPointId currentEntryPoint) {
        this.currentEntryPoint = currentEntryPoint;
    }

    public List<BaseNode> getNodes() {
        return this.nodes;
    }

    BaseNode getLastNode() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    public void setNodes(List<BaseNode> nodes) {
        this.nodes = nodes;
    }

    public RuleBasePartitionId getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    public boolean isStreamMode() {
        return this.temporal != null && !this.rule.isEager();
    }

    public long getExpirationOffset(Pattern pattern) {
        return this.temporal != null ? this.temporal.getExpirationOffset(pattern) : -1L;
    }

    void setTemporalDistance(TemporalDependencyMatrix temporal) {
        this.temporal = temporal;
    }

    public RuleImpl getRule() {
        return this.rule;
    }

    public void setRule(RuleImpl rule) {
        this.rule = rule;
        if (rule.isQuery()) {
            this.query = true;
        }
    }

    public GroupElement getSubRule() {
        return this.subRule;
    }

    void setSubRule(GroupElement subRule) {
        this.subRule = subRule;
    }

    public RuleComponent popRuleComponent() {
        return this.ruleComponent.pop();
    }

    public RuleComponent peekRuleComponent() {
        return this.ruleComponent.isEmpty() ? null : this.ruleComponent.peek();
    }

    public void pushRuleComponent(RuleComponent ruleComponent) {
        this.ruleComponent.push(ruleComponent);
    }

    public ObjectTypeNode getRootObjectTypeNode() {
        return this.rootObjectTypeNode;
    }

    void setRootObjectTypeNode(ObjectTypeNode source) {
        this.rootObjectTypeNode = source;
    }

    public Pattern[] getLastBuiltPatterns() {
        return this.lastBuiltPatterns;
    }

    public void setLastBuiltPattern(Pattern lastBuiltPattern) {
        if (this.lastBuiltPatterns == null) {
            this.lastBuiltPatterns = new Pattern[]{lastBuiltPattern, null};
        } else {
            this.lastBuiltPatterns[1] = this.lastBuiltPatterns[0];
            this.lastBuiltPatterns[0] = lastBuiltPattern;
        }
    }

    boolean isAttachPQN() {
        return this.attachPQN;
    }

    void setAttachPQN(boolean attachPQN) {
        this.attachPQN = attachPQN;
    }

    public KieComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    boolean isTerminated() {
        return this.terminated;
    }

    void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public String getConsequenceName() {
        return this.consequenceName;
    }

    public void setConsequenceName(String consequenceName) {
        this.consequenceName = consequenceName;
    }
}

