/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.dsl;

import java.io.IOException;
import java.io.InputStream;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewDSLFilePage
extends WizardNewFileCreationPage {
    private IWorkbench workbench;
    private boolean exampleContent;

    public NewDSLFilePage(IWorkbench workbench, IStructuredSelection selection) {
        super("createDSLFilePage", selection);
        this.setTitle("New DSL");
        this.setDescription("Create a new Domain Specific Language configuration");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setPageComplete(true);
    }

    public boolean finish(boolean exampleContent) {
        IFile newFile;
        this.exampleContent = exampleContent;
        String fileName = this.getFileName();
        if (!fileName.endsWith(".dsl")) {
            this.setFileName(String.valueOf(fileName) + ".dsl");
        }
        if ((newFile = this.createNewFile()) == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            DroolsEclipsePlugin.log(e);
            return false;
        }
        return true;
    }

    protected InputStream getInitialContents() {
        try {
            if (this.exampleContent) {
                return DroolsEclipsePlugin.getDefault().getBundle().getResource("org/drools/eclipse/wizard/dsl/template.dsl").openStream();
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

