/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.wizard.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.kie.eclipse.runtime.AbstractRuntime;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.wizard.project.IKieEmptyProjectWizardPage;
import org.kie.eclipse.wizard.project.KieProjectWizardPage;

public abstract class AbstractKieEmptyProjectWizardPage
extends KieProjectWizardPage
implements IKieEmptyProjectWizardPage {
    protected IRuntimeManager runtimeManager;
    protected List<IRuntime> runtimes = new ArrayList<IRuntime>();
    protected boolean isDefaultRuntime = true;
    protected IRuntime selectedRuntime;
    protected IRuntime effectiveRuntime;
    protected Combo runtimesCombo;
    protected Text pomArtifactIdText;
    protected String pomGroupId;
    protected String pomArtifactId;
    protected String pomVersion;
    protected String pomRuntimeVersion;
    KieProjectBuildType projectBuildType = KieProjectBuildType.JAVA_PROJECT;

    protected abstract void createControls(Composite var1);

    @Override
    public abstract IRuntimeManager getRuntimeManager();

    protected abstract IRuntime createRuntime();

    public abstract int showRuntimePreferenceDialog();

    public abstract String getProductName();

    public abstract String getProductId();

    public AbstractKieEmptyProjectWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Create an Empty Project");
        this.runtimeManager = this.getRuntimeManager();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite projectTypeRadioButtons = new Composite((Composite)this.getControl(), 0);
        projectTypeRadioButtons.setLayout((Layout)new GridLayout(3, false));
        projectTypeRadioButtons.setLayoutData((Object)new GridData(32));
        Label projectTypeLabel = new Label(projectTypeRadioButtons, 0);
        projectTypeLabel.setText("Build the Project using:");
        Button javaProjectButton = this.createRadioButton(projectTypeRadioButtons, "Java and " + this.getProductName() + " Runtime classes");
        Button mavenProjectButton = this.createRadioButton(projectTypeRadioButtons, "Maven");
        final Composite mavenControls = this.createMavenControls((Composite)this.getControl());
        final Composite javaControls = this.createJavaControls((Composite)this.getControl());
        mavenProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    AbstractKieEmptyProjectWizardPage.this.projectBuildType = KieProjectBuildType.MAVEN_PROJECT;
                    AbstractKieEmptyProjectWizardPage.this.setControlVisible((Control)javaControls, false);
                    AbstractKieEmptyProjectWizardPage.this.setControlVisible((Control)mavenControls, true);
                    AbstractKieEmptyProjectWizardPage.this.setPageComplete(AbstractKieEmptyProjectWizardPage.this.isPageComplete());
                }
            }
        });
        javaProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    AbstractKieEmptyProjectWizardPage.this.projectBuildType = KieProjectBuildType.JAVA_PROJECT;
                    AbstractKieEmptyProjectWizardPage.this.setControlVisible((Control)javaControls, true);
                    AbstractKieEmptyProjectWizardPage.this.setControlVisible((Control)mavenControls, false);
                    AbstractKieEmptyProjectWizardPage.this.setPageComplete(AbstractKieEmptyProjectWizardPage.this.isPageComplete());
                }
            }
        });
        boolean isMavenProject = this.projectBuildType == KieProjectBuildType.MAVEN_PROJECT;
        mavenProjectButton.setSelection(isMavenProject);
        javaProjectButton.setSelection(!isMavenProject);
        this.setControlVisible((Control)mavenControls, isMavenProject);
        this.setControlVisible((Control)javaControls, !isMavenProject);
        this.createControls((Composite)this.getControl());
    }

    protected Composite createMavenControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 20;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.createLabel(composite, "Group ID:");
        String text = this.getPomGroupId();
        final Text pomGroupIdText = this.createText(composite, text);
        pomGroupIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractKieEmptyProjectWizardPage.this.pomGroupId = pomGroupIdText.getText();
            }
        });
        this.createLabel(composite, "Artifact ID:");
        text = this.getPomArtifactId();
        this.pomArtifactIdText = this.createText(composite, text);
        this.pomArtifactIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractKieEmptyProjectWizardPage.this.pomArtifactId = AbstractKieEmptyProjectWizardPage.this.pomArtifactIdText.getText();
            }
        });
        this.createLabel(composite, "Version:");
        text = this.getPomVersion();
        final Text pomVersionText = this.createText(composite, text);
        pomVersionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractKieEmptyProjectWizardPage.this.pomVersion = pomVersionText.getText();
            }
        });
        return composite;
    }

    protected Composite createJavaControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 20;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label runtimesLabel = new Label(composite, 0);
        runtimesLabel.setText("Version:");
        runtimesLabel.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.runtimesCombo = new Combo(composite, 8);
        this.runtimesCombo.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.runtimesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Integer key = AbstractKieEmptyProjectWizardPage.this.runtimesCombo.getSelectionIndex();
                IRuntime rt = (IRuntime)AbstractKieEmptyProjectWizardPage.this.runtimesCombo.getData(key.toString());
                if (rt != AbstractKieEmptyProjectWizardPage.this.selectedRuntime) {
                    AbstractKieEmptyProjectWizardPage.this.selectedRuntime = rt;
                    AbstractKieEmptyProjectWizardPage.this.effectiveRuntime = null;
                }
                AbstractKieEmptyProjectWizardPage.this.isDefaultRuntime = rt.isDefault();
                AbstractKieEmptyProjectWizardPage.this.setPageComplete(AbstractKieEmptyProjectWizardPage.this.isPageComplete());
            }
        });
        Link changeWorkspaceSettingsLink = new Link(composite, 0);
        changeWorkspaceSettingsLink.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        changeWorkspaceSettingsLink.setText("<A>Manage Runtime definitions...</A>");
        changeWorkspaceSettingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractKieEmptyProjectWizardPage.this.showRuntimePreferenceDialog();
                AbstractKieEmptyProjectWizardPage.this.fillRuntimesCombo();
            }
        });
        this.fillRuntimesCombo();
        return composite;
    }

    public boolean isPageComplete() {
        if (super.validatePage()) {
            return this.getRuntime() != null;
        }
        return false;
    }

    protected boolean validatePage() {
        if (this.pomArtifactIdText != null) {
            this.pomArtifactIdText.setText(this.getProjectName());
        }
        return super.validatePage();
    }

    public String getPomGroupId() {
        if (this.pomGroupId == null) {
            return "com.sample";
        }
        return this.pomGroupId;
    }

    public String getPomArtifactId() {
        if (this.pomArtifactId == null) {
            return this.getProjectName();
        }
        return this.pomArtifactId;
    }

    public String getPomVersion() {
        if (this.pomVersion == null) {
            return "1.0.0-SNAPSHOT";
        }
        return this.pomVersion;
    }

    public String getPomRuntimeVersion() {
        if (this.pomRuntimeVersion == null) {
            return "6.4.0.Final";
        }
        return this.pomRuntimeVersion;
    }

    @Override
    public boolean shouldCreateMavenProject() {
        return this.projectBuildType == KieProjectBuildType.MAVEN_PROJECT;
    }

    @Override
    public boolean shouldCreateKJarProject() {
        AbstractRuntime.Version version = this.getRuntime().getVersion();
        return version.getMajor() >= 6;
    }

    private void fillRuntimesCombo() {
        this.runtimes.clear();
        IRuntime[] iRuntimeArray = this.runtimeManager.getConfiguredRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime rt = iRuntimeArray[n2];
            this.runtimes.add(rt);
            ++n2;
        }
        if (this.runtimeManager.getDefaultRuntime() == null) {
            this.isDefaultRuntime = false;
        }
        this.setErrorMessage(null);
        int i = 0;
        while (i < this.runtimesCombo.getItemCount()) {
            this.runtimesCombo.setData("" + i, null);
            ++i;
        }
        this.runtimesCombo.removeAll();
        Integer selectedKey = 0;
        Integer key = 0;
        for (IRuntime rt : this.runtimes) {
            String name = rt.getName();
            if (rt.getPath() == null) {
                name = String.valueOf(name) + " (will be created)";
            }
            if (rt.isDefault()) {
                selectedKey = key;
            }
            this.runtimesCombo.add(name);
            this.runtimesCombo.setData(key.toString(), (Object)rt);
            key = key + 1;
        }
        this.runtimesCombo.select(selectedKey.intValue());
        this.selectedRuntime = (IRuntime)this.runtimesCombo.getData(selectedKey.toString());
        this.effectiveRuntime = null;
        this.setPageComplete(this.isPageComplete());
    }

    @Override
    public IRuntime getRuntime() {
        if (this.shouldCreateMavenProject()) {
            return this.runtimeManager.createNewRuntime();
        }
        if (this.effectiveRuntime == null) {
            this.effectiveRuntime = this.runtimeManager.getEffectiveRuntime(this.selectedRuntime, this.isDefaultRuntime);
        }
        return this.effectiveRuntime;
    }

    @Override
    public boolean isDefaultRuntime() {
        return this.isDefaultRuntime;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public KieProjectBuildType getProjectBuildType() {
        return this.projectBuildType;
    }

    protected static enum KieProjectBuildType {
        JAVA_PROJECT,
        MAVEN_PROJECT;

    }
}

