/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.Signature;

public class CompletionUtil {
    protected static final Pattern INCOMPLETED_MVEL_EXPRESSION = Pattern.compile("[\\.\\(\\{\\[]\\Z", 32);
    protected static final Pattern COMPLETED_MVEL_EXPRESSION = Pattern.compile("]\\)\\}\\]\\Z", 32);
    protected static final Pattern MODIFY_PATTERN = Pattern.compile(".*modify\\s*\\(\\s*(.*)\\s*\\)(\\s*\\{(.*)\\s*\\}?)?", 32);
    protected static final Pattern START_OF_NEW_JAVA_STATEMENT = Pattern.compile(".*[;{}]\\s*", 32);
    protected static final Pattern START_OF_METHOD_ARGS = Pattern.compile(".*[\\(]\\s*", 32);

    private CompletionUtil() {
    }

    public static String stripLastWord(String prefix) {
        if ("".equals(prefix)) {
            return prefix;
        }
        if (prefix.charAt(prefix.length() - 1) == ' ') {
            return "";
        }
        char[] c = prefix.toCharArray();
        int start = 0;
        int i = c.length - 1;
        while (i >= 0) {
            if (Character.isWhitespace(c[i]) || c[i] == '(' || c[i] == ':' || c[i] == ';' || c[i] == '=' || c[i] == '<' || c[i] == '>' || c[i] == '.' || c[i] == '{' || c[i] == '}') {
                start = i + 1;
                break;
            }
            --i;
        }
        prefix = prefix.substring(start, prefix.length());
        return prefix;
    }

    public static String getPreviousExpression(String backText) {
        int separator = backText.lastIndexOf(59);
        if (separator < 0) {
            return backText;
        }
        return backText.substring(0, separator + 1);
    }

    public static String getLastExpression(String backText) {
        StringTokenizer st = new StringTokenizer(backText, ";");
        String last = "";
        while (st.hasMoreTokens()) {
            last = st.nextToken();
        }
        if (last.trim().length() == 0) {
            return backText;
        }
        return last;
    }

    public static String getInnerExpression(String backText) {
        String last = CompletionUtil.getLastExpression(backText).trim();
        char[] c = last.toCharArray();
        int start = 0;
        int i = c.length - 1;
        while (i >= 0) {
            if (Character.isWhitespace(c[i]) || c[i] == '(' || c[i] == '+' || c[i] == ')' || c[i] == '[' || c[i] == ']' || c[i] == ':' || c[i] == '=' || c[i] == '<' || c[i] == '>' || c[i] == ',' || c[i] == '{' || c[i] == '}') {
                start = i + 1;
                break;
            }
            --i;
        }
        last = last.substring(start);
        return last;
    }

    public static int nestedExpressionIndex(char[] chars, int start, char type) {
        int depth = 1;
        char term = type;
        switch (type) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
                break;
            }
            case '(': {
                term = ')';
            }
        }
        if (type == term) {
            ++start;
            while (start < chars.length) {
                if (chars[start] == type) {
                    return start;
                }
                ++start;
            }
        } else {
            ++start;
            while (start < chars.length) {
                if (chars[start] != '\'' && chars[start] != '\"') {
                    if (chars[start] == type) {
                        ++depth;
                    } else if (chars[start] == term && --depth == 0) {
                        return start;
                    }
                }
                ++start;
            }
        }
        return -1;
    }

    public static String stripWhiteSpace(String prefix) {
        if ("".equals(prefix)) {
            return prefix;
        }
        if (prefix.charAt(prefix.length() - 1) == ' ') {
            return "";
        }
        char[] c = prefix.toCharArray();
        int start = 0;
        int i = c.length - 1;
        while (i >= 0) {
            if (Character.isWhitespace(c[i])) {
                start = i + 1;
                break;
            }
            --i;
        }
        prefix = prefix.substring(start, prefix.length());
        return prefix;
    }

    public static String getCompilableText(String backText) {
        String trimed = backText.trim();
        if (trimed.endsWith(";")) {
            return backText.substring(0, backText.length() - 1);
        }
        if (trimed.endsWith(".") || trimed.endsWith(",")) {
            return backText.substring(0, backText.length() - 1);
        }
        if (COMPLETED_MVEL_EXPRESSION.matcher(backText).matches()) {
            return String.valueOf(backText) + ";";
        }
        return backText;
    }

    public static boolean isGetter(String methodName, int argCount, String returnedType) {
        return CompletionUtil.isAccessor(methodName, argCount, 0, "get", returnedType, "V", false);
    }

    public static boolean isSetter(String methodName, int argCount, String returnedType) {
        return CompletionUtil.isAccessor(methodName, argCount, 1, "set", returnedType, "V", true);
    }

    public static boolean isIsGetter(String methodName, int argCount, String returnedType) {
        return CompletionUtil.isAccessor(methodName, argCount, 0, "is", returnedType, "Z", true);
    }

    public static String getPropertyName(String methodName, int parameterCount, String returnType) {
        if (methodName == null) {
            return null;
        }
        String simpleName = methodName.replaceAll("\\(\\)", "");
        int prefixLength = 0;
        if (CompletionUtil.isIsGetter(simpleName, parameterCount, returnType)) {
            prefixLength = 2;
        } else if (CompletionUtil.isGetter(simpleName, parameterCount, returnType) || CompletionUtil.isSetter(simpleName, parameterCount, returnType)) {
            prefixLength = 3;
        } else {
            return methodName;
        }
        char firstChar = Character.toLowerCase(simpleName.charAt(prefixLength));
        String propertyName = String.valueOf(firstChar) + simpleName.substring(prefixLength + 1);
        return propertyName;
    }

    public static String getPropertyName(String methodName, char[] signature) {
        if (signature == null || methodName == null) {
            return methodName;
        }
        int parameterCount = Signature.getParameterCount((char[])signature);
        String returnType = new String(Signature.getReturnType((char[])signature));
        return CompletionUtil.getPropertyName(methodName, parameterCount, returnType);
    }

    public static String getWritablePropertyName(String methodName, int parameterCount, String returnType) {
        if (methodName == null) {
            return null;
        }
        String simpleName = methodName.replaceAll("\\(\\)", "");
        if (!CompletionUtil.isSetter(simpleName, parameterCount, returnType)) {
            return methodName;
        }
        int prefixLength = 3;
        char firstChar = Character.toLowerCase(simpleName.charAt(prefixLength));
        String propertyName = String.valueOf(firstChar) + simpleName.substring(prefixLength + 1);
        return propertyName;
    }

    public static String getWritablePropertyName(String methodName, char[] signature) {
        if (signature == null || methodName == null) {
            return methodName;
        }
        int parameterCount = Signature.getParameterCount((char[])signature);
        String returnType = new String(Signature.getReturnType((char[])signature));
        return CompletionUtil.getWritablePropertyName(methodName, parameterCount, returnType);
    }

    private static boolean isAccessor(String methodName, int actualParameterCount, int requiredParameterCount, String prefix, String returnType, String requiredReturnType, boolean includeType) {
        if (methodName.length() < prefix.length() + 1) {
            return false;
        }
        if (!methodName.startsWith(prefix)) {
            return false;
        }
        if (actualParameterCount != requiredParameterCount) {
            return false;
        }
        return !(includeType ? !requiredReturnType.equals(returnType) : requiredReturnType.equals(returnType));
    }

    public static boolean isStartOfNewStatement(String text, String prefix) {
        String javaTextWithoutPrefix = text.substring(0, text.length() - prefix.length());
        return "".equals(javaTextWithoutPrefix.trim()) || START_OF_NEW_JAVA_STATEMENT.matcher(javaTextWithoutPrefix).matches();
    }

    public static String getLastLine(String text) {
        BufferedReader reader = new BufferedReader(new StringReader(text));
        String line = null;
        String lastLine = null;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                lastLine = line;
            }
        }
        catch (IOException iOException) {}
        return lastLine;
    }

    public static String getSimpleClassName(Class<?> cls) {
        int lastIndex = cls.getName().lastIndexOf(36);
        if (lastIndex < 0) {
            lastIndex = cls.getName().lastIndexOf(46);
        }
        if (cls.isArray()) {
            return String.valueOf(cls.getName().substring(lastIndex + 1)) + "[]";
        }
        return cls.getName().substring(lastIndex + 1);
    }

    public static String getTextWithoutPrefix(String javaText, String prefix) {
        int endIndex = javaText.length() - prefix.length();
        String javaTextWithoutPrefix = javaText;
        if (endIndex >= 0) {
            javaTextWithoutPrefix = javaText.substring(0, endIndex);
        }
        return javaTextWithoutPrefix;
    }

    public static boolean isStartOfDialectExpression(String text) {
        return "".equals(text.trim()) || START_OF_NEW_JAVA_STATEMENT.matcher(text).matches();
    }

    public static boolean isStartOfMethodArgsExpression(String text) {
        return START_OF_NEW_JAVA_STATEMENT.matcher(text).matches();
    }
}

