/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.DMNScope;

public class DMNCompilerContext {
    private final DMNFEELHelper feelHelper;
    private Stack<DMNScope> stack = new Stack();

    public DMNCompilerContext(DMNFEELHelper feelHelper) {
        this.feelHelper = feelHelper;
        this.stack.push(new DMNScope());
    }

    public void enterFrame() {
        this.stack.push(new DMNScope(this.stack.peek()));
    }

    public void exitFrame() {
        this.stack.pop();
    }

    public DMNType resolve(String name) {
        return this.stack.peek().resolve(name);
    }

    public void setVariable(String name, DMNType type) {
        this.stack.peek().setVariable(name, type);
    }

    public Map<String, DMNType> getVariables() {
        HashMap<String, DMNType> variables = new HashMap<String, DMNType>();
        for (DMNScope scope : this.stack) {
            variables.putAll(scope.getVariables());
        }
        return variables;
    }

    public DMNFEELHelper getFeelHelper() {
        return this.feelHelper;
    }
}

