/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.preferences;

import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.preferences.AbstractKiePropertyPage;
import org.kie.eclipse.navigator.preferences.JsonPreferenceStore;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.IKieServiceDelegate;
import org.kie.eclipse.server.IKieSpaceHandler;

public abstract class AbstractKieJsonPropertyPage
extends AbstractKiePropertyPage {
    protected IPreferenceStore preferenceStore;
    protected JsonObject properties;

    public AbstractKieJsonPropertyPage() {
        super(1);
    }

    @Override
    protected String getPreferenceName(String name) {
        return name;
    }

    @Override
    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.properties = new JsonObject(this.getResourceHandler().getProperties());
            this.preferenceStore = new JsonPreferenceStore(this.properties);
        }
        return this.preferenceStore;
    }

    @Override
    protected void performDefaults() {
        this.properties.copyFrom(this.getResourceHandler().getProperties());
        super.performDefaults();
    }

    @Override
    public boolean performOk() {
        JsonObject oldProperties;
        boolean rtn = super.performOk();
        if (rtn && !this.properties.equals((Object)(oldProperties = this.getResourceHandler().getProperties()))) {
            String oldName = this.getResourceHandler().getName();
            this.getResourceHandler().setProperties(this.properties);
            IKieResourceHandler handler = this.getResourceHandler();
            IKieServiceDelegate delegate = handler.getDelegate();
            try {
                if (handler instanceof IKieSpaceHandler) {
                    delegate.updateSpace(oldName, (IKieSpaceHandler)handler);
                } else if (handler instanceof IKieRepositoryHandler) {
                    delegate.updateRepository(oldName, (IKieRepositoryHandler)handler);
                }
                if (handler instanceof IKieProjectHandler) {
                    delegate.updateProject(oldName, (IKieProjectHandler)handler);
                }
                IContainerNode<?> container = this.getContentNode().getParent();
                container.refresh();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.getResourceHandler().setProperties(oldProperties);
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
            }
        }
        return rtn;
    }
}

