/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.lang.reflect.InvocationTargetException;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.editors.ZoomInAction2;
import org.drools.eclipse.editors.ZoomOutAction2;
import org.drools.eclipse.editors.rete.ReteViewer;
import org.drools.eclipse.editors.rete.model.ReteGraph;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;

public class DRLRuleEditor2
extends FormEditor {
    private DRLRuleEditor textEditor;
    private ReteViewer reteViewer;
    private ZoomComboContributionItem zitem;
    private ZoomInAction2 zoomIn;
    private ZoomOutAction2 zoomOut;
    protected ReteGraph graph;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(input.getName());
    }

    protected void addPages() {
        try {
            this.textEditor = new DRLRuleEditor(){

                public void close(boolean save) {
                    super.close(save);
                    DRLRuleEditor2.this.close(save);
                }

                protected void setPartName(String partName) {
                    super.setPartName(partName);
                    DRLRuleEditor2.this.setPartName(partName);
                }
            };
            this.reteViewer = new ReteViewer(this.textEditor);
            int text = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            int rete = this.addPage((IEditorPart)this.reteViewer, this.getEditorInput());
            this.setPageText(text, "Text Editor");
            this.setPageText(rete, "Rete Tree");
            this.textEditor.getDocumentProvider().getDocument((Object)this.getEditorInput()).addDocumentListener(new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    DRLRuleEditor2.this.reteViewer.fireDocumentChanged();
                }
            });
        }
        catch (PartInitException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.textEditor.doSave(monitor);
        this.setInput(this.getEditorInput());
    }

    public void doSaveAs() {
        this.textEditor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return this.textEditor.isSaveAsAllowed();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ZoomManager.class) {
            if (this.getActiveEditor() instanceof ReteViewer) {
                return this.reteViewer.getAdapter(adapter);
            }
            if (this.getActiveEditor() instanceof DRLRuleEditor) {
                return null;
            }
        } else {
            if (adapter == ZoomInAction2.class) {
                return this.zoomIn;
            }
            if (adapter == ZoomOutAction2.class) {
                return this.zoomOut;
            }
            if (adapter == ZoomComboContributionItem.class) {
                return this.zitem;
            }
        }
        return this.textEditor.getAdapter(adapter);
    }

    private void updateZoomItems() {
        this.updateZoomIn();
        this.updateZoomOut();
        this.updateZoomCombo();
    }

    private void updateZoomCombo() {
        if (this.zitem != null) {
            this.zitem.setZoomManager(this.getZoomManager());
        }
    }

    private void updateZoomIn() {
        boolean zoomActive;
        boolean bl = zoomActive = this.getZoomManager() != null;
        if (this.zoomIn != null) {
            this.zoomIn.setZoomManager(this.getZoomManager());
            this.zoomIn.setEnabled(zoomActive);
        }
    }

    private void updateZoomOut() {
        boolean zoomActive;
        boolean bl = zoomActive = this.getZoomManager() != null;
        if (this.zoomOut != null) {
            this.zoomOut.setZoomManager(this.getZoomManager());
            this.zoomOut.setEnabled(zoomActive);
        }
    }

    public void setZoomComboContributionItem(ZoomComboContributionItem zitem) {
        this.zitem = zitem;
        this.updateZoomCombo();
    }

    private ZoomManager getZoomManager() {
        return (ZoomManager)this.getAdapter(ZoomManager.class);
    }

    public void setZoomOutAction(ZoomOutAction2 zoomOutAction) {
        this.zoomOut = zoomOutAction;
        this.updateZoomOut();
    }

    public void setZoomInAction(ZoomInAction2 zoomInAction) {
        this.zoomIn = zoomInAction;
        this.updateZoomIn();
    }

    public void setFocus() {
        if (this.getActivePage() == 1) {
            boolean reteFailed = false;
            this.graph = null;
            try {
                final String contents = this.textEditor.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            DRLRuleEditor2.this.graph = DRLRuleEditor2.this.reteViewer.loadReteModel(monitor, contents);
                        }
                        catch (Throwable e) {
                            if (e instanceof InvocationTargetException) {
                                throw (InvocationTargetException)e;
                            }
                            if (e instanceof InterruptedException) {
                                throw (InterruptedException)e;
                            }
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                this.getEditorSite().getWorkbenchWindow().getWorkbench().getProgressService().busyCursorWhile(runnable);
                this.reteViewer.drawGraph(this.graph);
            }
            catch (InvocationTargetException e) {
                System.out.println(e.getTargetException().getMessage());
                if (e.getTargetException() != null && "Unable to parse rules to show RETE view!".equals(e.getTargetException().getMessage())) {
                    Status status = new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), -1, "Unable to show Rete Tree when rules cannot be parsed correctly.", null);
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Rete Tree Build Error", (String)"Unable to parse rules, please correct rules first.", (IStatus)status);
                } else {
                    this.handleError(e);
                }
                reteFailed = true;
            }
            catch (InterruptedException interruptedException) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Rete Tree Error!", (String)"Rete Tree Calculation Cancelled!");
                reteFailed = true;
            }
            catch (Throwable t) {
                this.handleError(t);
                reteFailed = true;
            }
            if (reteFailed) {
                this.setActivePage(0);
            }
        }
        super.setFocus();
        this.updateZoomItems();
    }

    private void handleError(Throwable t) {
        String message;
        DroolsEclipsePlugin.log(t);
        Throwable cause = t.getCause();
        if (cause == null) {
            cause = t;
        }
        if ((message = String.valueOf(cause.getClass().getName()) + ": " + cause.getMessage()) == null || message.length() == 0) {
            message = "Uncategorized Error!";
        }
        Status status = new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), -1, message, null);
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Rete Tree Build Error!", (String)"Rete Tree Build Error!", (IStatus)status);
    }

    public void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
    }
}

