/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart.work;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.WorkDefinition;
import org.jbpm.process.core.WorkEditor;
import org.jbpm.process.core.impl.WorkImpl;

public class HumanTaskCustomEditor
extends EditBeanDialog<Work>
implements WorkEditor {
    private static final String COMPONENT_SEPARATOR = "^";
    private static final String COMPONENT_SEPARATOR_ESCAPED = "\\^";
    private static final String ELEMENT_SEPARATOR = "@";
    private static final String ATTRIBUTES_SEPARATOR = "|";
    private static final String ATTRIBUTES_SEPARATOR_ESCAPED = "\\|";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String[] KNOWN_KEYS = new String[]{"users", "groups", "from", "tousers", "togroups", "replyTo", "subject", "body"};
    private Text nameText;
    private Text actorText;
    private Text groupText;
    private Text commentText;
    private Text priorityText;
    private Button skippableButton;
    private Text contentText;
    private Text createdByText;
    private Text localeText;
    private List<Reassignment> reassignments = new ArrayList<Reassignment>();
    private List<Notification> notifications = new ArrayList<Notification>();
    private Text notifyFromText;
    private Text notifyToText;
    private Text notifyToGroupsText;
    private Text notifyReplyToText;
    private Text notifySubjectText;
    private Text notifyBodyText;
    private Combo notifyTypeText;
    private Text notifyExpiresAtText;

    public HumanTaskCustomEditor(Shell parentShell) {
        super(parentShell, "Human Task Editor");
        this.setBlockOnOpen(true);
    }

    @Override
    protected Point getInitialSize() {
        return new Point(460, 660);
    }

    protected Control createDialogArea(final Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        final ScrolledComposite scroll = new ScrolledComposite(composite, 2560);
        scroll.setLayout((Layout)new FillLayout());
        final TabFolder tabFolder = new TabFolder((Composite)scroll, 0);
        tabFolder.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                tabFolder.setSize(parent.getSize().x, parent.getSize().y);
            }
        });
        scroll.setContent((Control)tabFolder);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                tabFolder.setSize(parent.getSize().x, parent.getSize().y);
            }
        });
        scroll.setAlwaysShowScrollBars(true);
        scroll.setExpandVertical(true);
        scroll.setExpandHorizontal(true);
        scroll.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                scroll.setMinHeight(parent.computeSize((int)-1, (int)-1).y);
            }
        });
        this.createGeneralTab(tabFolder);
        this.createReassignmentTab(tabFolder);
        this.createNotificationTab(tabFolder);
        return composite;
    }

    private void createGeneralTab(TabFolder tabFolder) {
        TabItem headersTabItem = new TabItem(tabFolder, 0);
        headersTabItem.setText("General");
        Composite container = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 2;
        container.setLayout((Layout)gridLayout);
        headersTabItem.setControl((Control)container);
        Work work = (Work)this.getValue();
        Label nameLabel = new Label(container, 0);
        nameLabel.setText("Name: ");
        this.nameText = new Text(container, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameText.setLayoutData((Object)gridData);
        String name = (String)work.getParameter("TaskName");
        this.nameText.setText(name == null ? "" : name);
        Label label = new Label(container, 0);
        label.setText("Actor(s): ");
        this.actorText = new Text(container, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.actorText.setLayoutData((Object)gridData);
        String value = (String)work.getParameter("ActorId");
        this.actorText.setText(value == null ? "" : value);
        label = new Label(container, 0);
        label.setText("Group(s): ");
        this.groupText = new Text(container, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.groupText.setLayoutData((Object)gridData);
        value = (String)work.getParameter("GroupId");
        this.groupText.setText(value == null ? "" : value);
        label = new Label(container, 0);
        label.setText("Comment: ");
        this.commentText = new Text(container, 2);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.commentText.setLayoutData((Object)gridData);
        value = (String)work.getParameter("Comment");
        this.commentText.setText(value == null ? "" : value.toString());
        label = new Label(container, 0);
        label.setText("Priority: ");
        this.priorityText = new Text(container, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.priorityText.setLayoutData((Object)gridData);
        value = (String)work.getParameter("Priority");
        this.priorityText.setText(value == null ? "" : value);
        this.skippableButton = new Button(container, 16416);
        this.skippableButton.setText("Skippable");
        value = (String)work.getParameter("Skippable");
        this.skippableButton.setSelection("true".equals(value));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.skippableButton.setLayoutData((Object)gridData);
        label = new Label(container, 0);
        label.setText("Content: ");
        this.contentText = new Text(container, 2);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.contentText.setLayoutData((Object)gridData);
        value = (String)work.getParameter("Content");
        this.contentText.setText(value == null ? "" : value.toString());
        label = new Label(container, 0);
        label.setText("Created by: ");
        this.createdByText = new Text(container, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.createdByText.setLayoutData((Object)gridData);
        value = (String)work.getParameter("CreatedBy");
        this.createdByText.setText(value == null ? "" : value.toString());
        label = new Label(container, 0);
        label.setText("Locale: ");
        this.localeText = new Text(container, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.localeText.setLayoutData((Object)gridData);
        value = (String)work.getParameter("Locale");
        this.localeText.setText(value == null ? "en-UK" : value.toString());
    }

    private void createReassignmentTab(TabFolder tabFolder) {
        String reassign;
        int n;
        int n2;
        String[] stringArray;
        String[] reassigns;
        Work work = (Work)this.getValue();
        String notStartedReassign = (String)work.getParameter("NotStartedReassign");
        String notCompletedReassign = (String)work.getParameter("NotCompletedReassign");
        if (notStartedReassign != null) {
            stringArray = reassigns = notStartedReassign.split(COMPONENT_SEPARATOR_ESCAPED);
            n2 = reassigns.length;
            n = 0;
            while (n < n2) {
                reassign = stringArray[n];
                if (reassign != null && reassign.length() > 0) {
                    this.reassignments.add(new Reassignment(reassign, "not-started"));
                }
                ++n;
            }
        }
        if (notCompletedReassign != null) {
            stringArray = reassigns = notCompletedReassign.split(COMPONENT_SEPARATOR_ESCAPED);
            n2 = reassigns.length;
            n = 0;
            while (n < n2) {
                reassign = stringArray[n];
                if (reassign != null && reassign.length() > 0) {
                    this.reassignments.add(new Reassignment(reassign, "not-completed"));
                }
                ++n;
            }
        }
        TabItem headersTabItem = new TabItem(tabFolder, 0);
        headersTabItem.setText("Reassignment");
        Composite container = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 2;
        container.setLayout((Layout)gridLayout);
        headersTabItem.setControl((Control)container);
        final TableViewer tableViewer = new TableViewer(container, 67584);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.setLabelProvider((CellLabelProvider)new ReassignmentUsersLabelProvider());
        column.setEditingSupport((EditingSupport)new ReassignmentUsersEditing(tableViewer));
        column.getColumn().setText("Users");
        column.getColumn().setWidth(100);
        column.getColumn().setMoveable(true);
        TableViewerColumn column2 = new TableViewerColumn(tableViewer, 0);
        column2.setLabelProvider((CellLabelProvider)new ReassignmentGroupsLabelProvider());
        column2.setEditingSupport((EditingSupport)new ReassignmentGroupsEditing(tableViewer));
        column2.getColumn().setText("Groups");
        column2.getColumn().setWidth(100);
        column2.getColumn().setMoveable(true);
        TableViewerColumn column3 = new TableViewerColumn(tableViewer, 0);
        column3.setLabelProvider((CellLabelProvider)new ReassignmentExpiresAtLabelProvider());
        column3.setEditingSupport((EditingSupport)new ReassignmentExpiresAtEditing(tableViewer));
        column3.getColumn().setText("Expires At");
        column3.getColumn().setWidth(100);
        column3.getColumn().setMoveable(true);
        TableViewerColumn column4 = new TableViewerColumn(tableViewer, 0);
        column4.setLabelProvider((CellLabelProvider)new ReassignmentTypeLabelProvider());
        column4.setEditingSupport((EditingSupport)new ReassignmentTypeEditing(tableViewer));
        column4.getColumn().setText("Type");
        column4.getColumn().setWidth(100);
        column4.getColumn().setMoveable(true);
        final Table table = tableViewer.getTable();
        GridData gd_table = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_table.heightHint = 128;
        table.setLayoutData((Object)gd_table);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        tableViewer.setContentProvider((IContentProvider)new ReassignmentContentProvider());
        tableViewer.setInput(this.reassignments);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        composite.setLayout((Layout)new RowLayout());
        Button addButton = new Button(composite, 0);
        addButton.setText("Add");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Reassignment reassignment = new Reassignment();
                HumanTaskCustomEditor.this.reassignments.add(reassignment);
                tableViewer.add((Object)reassignment);
                tableViewer.refresh();
            }

            public void widgetSelected(SelectionEvent e) {
                Reassignment reassignment = new Reassignment();
                HumanTaskCustomEditor.this.reassignments.add(reassignment);
                tableViewer.add((Object)reassignment);
                tableViewer.refresh();
            }
        });
        Button deleteButton = new Button(composite, 0);
        deleteButton.setText("Remove");
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] items = table.getSelection();
                if (items != null && items.length > 0) {
                    HumanTaskCustomEditor.this.reassignments.remove((Reassignment)items[0].getData());
                    tableViewer.remove((Object)items[0]);
                    tableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                TableItem[] items = table.getSelection();
                if (items != null && items.length > 0) {
                    HumanTaskCustomEditor.this.reassignments.remove((Reassignment)items[0].getData());
                    tableViewer.remove((Object)items[0]);
                    tableViewer.refresh();
                }
            }
        });
    }

    private void createNotificationTab(TabFolder tabFolder) {
        String notification;
        int n;
        int n2;
        String[] stringArray;
        String[] notifies;
        Work work = (Work)this.getValue();
        String notStartedNotify = (String)work.getParameter("NotStartedNotify");
        String notCompletedNotify = (String)work.getParameter("NotCompletedNotify");
        if (notStartedNotify != null) {
            stringArray = notifies = notStartedNotify.split(COMPONENT_SEPARATOR_ESCAPED);
            n2 = notifies.length;
            n = 0;
            while (n < n2) {
                notification = stringArray[n];
                if (notification != null && notification.length() > 0) {
                    this.notifications.add(new Notification(notification, "not-started"));
                }
                ++n;
            }
        }
        if (notCompletedNotify != null) {
            stringArray = notifies = notCompletedNotify.split(COMPONENT_SEPARATOR_ESCAPED);
            n2 = notifies.length;
            n = 0;
            while (n < n2) {
                notification = stringArray[n];
                if (notification != null && notification.length() > 0) {
                    this.notifications.add(new Notification(notification, "not-completed"));
                }
                ++n;
            }
        }
        TabItem headersTabItem = new TabItem(tabFolder, 0);
        headersTabItem.setText("Notifications");
        Composite container = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 2;
        container.setLayout((Layout)gridLayout);
        headersTabItem.setControl((Control)container);
        final TableViewer tableViewer = new TableViewer(container, 67584);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.setLabelProvider((CellLabelProvider)new NotificationsLabelProvider());
        column.setEditingSupport((EditingSupport)new NotificationsEditing(tableViewer));
        column.getColumn().setText("Notifications");
        column.getColumn().setWidth(400);
        column.getColumn().setMoveable(true);
        Label typeLabel = new Label(container, 0);
        typeLabel.setLayoutData((Object)new GridData());
        typeLabel.setText("Type");
        this.notifyTypeText = new Combo(container, 0);
        this.notifyTypeText.add("not-started");
        this.notifyTypeText.add("not-completed");
        this.notifyTypeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label expiresAtLabel = new Label(container, 0);
        expiresAtLabel.setLayoutData((Object)new GridData());
        expiresAtLabel.setText("ExpiresAt");
        this.notifyExpiresAtText = new Text(container, 0);
        this.notifyExpiresAtText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label notifyFromLabel = new Label(container, 0);
        notifyFromLabel.setLayoutData((Object)new GridData());
        notifyFromLabel.setText("From");
        this.notifyFromText = new Text(container, 0);
        this.notifyFromText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label notifyToLabel = new Label(container, 0);
        notifyToLabel.setText("To Users");
        this.notifyToText = new Text(container, 0);
        this.notifyToText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label notifyToGroupsLabel = new Label(container, 0);
        notifyToGroupsLabel.setText("To Groups");
        this.notifyToGroupsText = new Text(container, 0);
        this.notifyToGroupsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label notifyReplyToLabel = new Label(container, 0);
        notifyReplyToLabel.setText("Reply To");
        this.notifyReplyToText = new Text(container, 0);
        this.notifyReplyToText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label subjectLabel = new Label(container, 0);
        subjectLabel.setLayoutData((Object)new GridData());
        subjectLabel.setText("Subject");
        this.notifySubjectText = new Text(container, 0);
        this.notifySubjectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label bodyLabel = new Label(container, 0);
        bodyLabel.setText("Body");
        this.notifyBodyText = new Text(container, 2562);
        GridData gd_bodyText = new GridData(4, 0x1000000, true, false);
        gd_bodyText.heightHint = 100;
        this.notifyBodyText.setLayoutData((Object)gd_bodyText);
        final Table table = tableViewer.getTable();
        GridData gd_table = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_table.heightHint = 100;
        table.setLayoutData((Object)gd_table);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = table.getSelection();
                if (items != null && items.length > 0) {
                    int index = HumanTaskCustomEditor.this.notifications.indexOf((Notification)items[0].getData());
                    Notification notification = (Notification)HumanTaskCustomEditor.this.notifications.get(index);
                    HumanTaskCustomEditor.this.notifyFromText.setText(notification.getFrom());
                    HumanTaskCustomEditor.this.notifyToText.setText(notification.getTo());
                    HumanTaskCustomEditor.this.notifyToGroupsText.setText(notification.getToGroups());
                    HumanTaskCustomEditor.this.notifyReplyToText.setText(notification.getReplyTo());
                    HumanTaskCustomEditor.this.notifySubjectText.setText(notification.getSubject());
                    HumanTaskCustomEditor.this.notifyBodyText.setText(notification.getBody());
                    HumanTaskCustomEditor.this.notifyTypeText.setText(notification.getType());
                    HumanTaskCustomEditor.this.notifyExpiresAtText.setText(notification.getExpiresAt());
                } else {
                    HumanTaskCustomEditor.this.notifyFromText.setText("");
                    HumanTaskCustomEditor.this.notifyToText.setText("");
                    HumanTaskCustomEditor.this.notifyToGroupsText.setText("");
                    HumanTaskCustomEditor.this.notifyReplyToText.setText("");
                    HumanTaskCustomEditor.this.notifySubjectText.setText("");
                    HumanTaskCustomEditor.this.notifyBodyText.setText("");
                    HumanTaskCustomEditor.this.notifyTypeText.setText("");
                    HumanTaskCustomEditor.this.notifyExpiresAtText.setText("");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem[] items = table.getSelection();
                if (items != null && items.length > 0) {
                    int index = HumanTaskCustomEditor.this.notifications.indexOf((Notification)items[0].getData());
                    Notification notification = (Notification)HumanTaskCustomEditor.this.notifications.get(index);
                    HumanTaskCustomEditor.this.notifyFromText.setText(notification.getFrom());
                    HumanTaskCustomEditor.this.notifyToText.setText(notification.getTo());
                    HumanTaskCustomEditor.this.notifyToGroupsText.setText(notification.getToGroups());
                    HumanTaskCustomEditor.this.notifyReplyToText.setText(notification.getReplyTo());
                    HumanTaskCustomEditor.this.notifySubjectText.setText(notification.getSubject());
                    HumanTaskCustomEditor.this.notifyBodyText.setText(notification.getBody());
                    HumanTaskCustomEditor.this.notifyTypeText.setText(notification.getType());
                    HumanTaskCustomEditor.this.notifyExpiresAtText.setText(notification.getExpiresAt());
                } else {
                    HumanTaskCustomEditor.this.notifyFromText.setText("");
                    HumanTaskCustomEditor.this.notifyToText.setText("");
                    HumanTaskCustomEditor.this.notifyToGroupsText.setText("");
                    HumanTaskCustomEditor.this.notifyReplyToText.setText("");
                    HumanTaskCustomEditor.this.notifySubjectText.setText("");
                    HumanTaskCustomEditor.this.notifyBodyText.setText("");
                    HumanTaskCustomEditor.this.notifyTypeText.setText("");
                    HumanTaskCustomEditor.this.notifyExpiresAtText.setText("");
                }
            }
        });
        tableViewer.setContentProvider((IContentProvider)new NotificationsContentProvider());
        tableViewer.setInput(this.notifications);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        composite.setLayout((Layout)new RowLayout());
        Button addButton = new Button(composite, 0);
        addButton.setText("Add");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Notification notification = new Notification();
                notification.setFrom(HumanTaskCustomEditor.this.notifyFromText.getText());
                notification.setTo(HumanTaskCustomEditor.this.notifyToText.getText());
                notification.setToGroups(HumanTaskCustomEditor.this.notifyToGroupsText.getText());
                notification.setReplyTo(HumanTaskCustomEditor.this.notifyReplyToText.getText());
                notification.setSubject(HumanTaskCustomEditor.this.notifySubjectText.getText());
                notification.setBody(HumanTaskCustomEditor.this.notifyBodyText.getText());
                notification.setType(HumanTaskCustomEditor.this.notifyTypeText.getText());
                notification.setExpiresAt(HumanTaskCustomEditor.this.notifyExpiresAtText.getText());
                HumanTaskCustomEditor.this.notifications.add(notification);
                tableViewer.add((Object)notification);
                tableViewer.refresh();
                HumanTaskCustomEditor.this.notifyFromText.setText("");
                HumanTaskCustomEditor.this.notifyToText.setText("");
                HumanTaskCustomEditor.this.notifyToGroupsText.setText("");
                HumanTaskCustomEditor.this.notifyReplyToText.setText("");
                HumanTaskCustomEditor.this.notifySubjectText.setText("");
                HumanTaskCustomEditor.this.notifyBodyText.setText("");
                HumanTaskCustomEditor.this.notifyTypeText.setText("");
                HumanTaskCustomEditor.this.notifyExpiresAtText.setText("");
            }

            public void widgetSelected(SelectionEvent e) {
                Notification notification = new Notification();
                notification.setFrom(HumanTaskCustomEditor.this.notifyFromText.getText());
                notification.setTo(HumanTaskCustomEditor.this.notifyToText.getText());
                notification.setToGroups(HumanTaskCustomEditor.this.notifyToGroupsText.getText());
                notification.setReplyTo(HumanTaskCustomEditor.this.notifyReplyToText.getText());
                notification.setSubject(HumanTaskCustomEditor.this.notifySubjectText.getText());
                notification.setBody(HumanTaskCustomEditor.this.notifyBodyText.getText());
                notification.setType(HumanTaskCustomEditor.this.notifyTypeText.getText());
                notification.setExpiresAt(HumanTaskCustomEditor.this.notifyExpiresAtText.getText());
                HumanTaskCustomEditor.this.notifications.add(notification);
                tableViewer.add((Object)notification);
                tableViewer.refresh();
                HumanTaskCustomEditor.this.notifyFromText.setText("");
                HumanTaskCustomEditor.this.notifyToText.setText("");
                HumanTaskCustomEditor.this.notifyToGroupsText.setText("");
                HumanTaskCustomEditor.this.notifyReplyToText.setText("");
                HumanTaskCustomEditor.this.notifySubjectText.setText("");
                HumanTaskCustomEditor.this.notifyBodyText.setText("");
                HumanTaskCustomEditor.this.notifyTypeText.setText("");
                HumanTaskCustomEditor.this.notifyExpiresAtText.setText("");
            }
        });
        Button deleteButton = new Button(composite, 0);
        deleteButton.setText("Remove");
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] items = table.getSelection();
                if (items != null && items.length > 0) {
                    HumanTaskCustomEditor.this.notifications.remove((Notification)items[0].getData());
                    tableViewer.remove((Object)items[0]);
                    tableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                TableItem[] items = table.getSelection();
                if (items != null && items.length > 0) {
                    HumanTaskCustomEditor.this.notifications.remove((Notification)items[0].getData());
                    tableViewer.remove((Object)items[0]);
                    tableViewer.refresh();
                }
            }
        });
        Button updateButton = new Button(composite, 0);
        updateButton.setText("Update");
        updateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] items = table.getSelection();
                if (items != null && items.length > 0) {
                    int index = HumanTaskCustomEditor.this.notifications.indexOf((Notification)items[0].getData());
                    Notification notification = (Notification)HumanTaskCustomEditor.this.notifications.get(index);
                    notification.setFrom(HumanTaskCustomEditor.this.notifyFromText.getText());
                    notification.setTo(HumanTaskCustomEditor.this.notifyToText.getText());
                    notification.setToGroups(HumanTaskCustomEditor.this.notifyToGroupsText.getText());
                    notification.setReplyTo(HumanTaskCustomEditor.this.notifyReplyToText.getText());
                    notification.setSubject(HumanTaskCustomEditor.this.notifySubjectText.getText());
                    notification.setBody(HumanTaskCustomEditor.this.notifyBodyText.getText());
                    notification.setType(HumanTaskCustomEditor.this.notifyTypeText.getText());
                    notification.setExpiresAt(HumanTaskCustomEditor.this.notifyExpiresAtText.getText());
                    tableViewer.refresh();
                    HumanTaskCustomEditor.this.notifyFromText.setText("");
                    HumanTaskCustomEditor.this.notifyToText.setText("");
                    HumanTaskCustomEditor.this.notifyToGroupsText.setText("");
                    HumanTaskCustomEditor.this.notifyReplyToText.setText("");
                    HumanTaskCustomEditor.this.notifySubjectText.setText("");
                    HumanTaskCustomEditor.this.notifyBodyText.setText("");
                    HumanTaskCustomEditor.this.notifyTypeText.setText("");
                    HumanTaskCustomEditor.this.notifyExpiresAtText.setText("");
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                TableItem[] items = table.getSelection();
                if (items != null && items.length > 0) {
                    int index = HumanTaskCustomEditor.this.notifications.indexOf((Notification)items[0].getData());
                    Notification notification = (Notification)HumanTaskCustomEditor.this.notifications.get(index);
                    notification.setFrom(HumanTaskCustomEditor.this.notifyFromText.getText());
                    notification.setTo(HumanTaskCustomEditor.this.notifyToText.getText());
                    notification.setToGroups(HumanTaskCustomEditor.this.notifyToGroupsText.getText());
                    notification.setReplyTo(HumanTaskCustomEditor.this.notifyReplyToText.getText());
                    notification.setSubject(HumanTaskCustomEditor.this.notifySubjectText.getText());
                    notification.setBody(HumanTaskCustomEditor.this.notifyBodyText.getText());
                    notification.setType(HumanTaskCustomEditor.this.notifyTypeText.getText());
                    notification.setExpiresAt(HumanTaskCustomEditor.this.notifyExpiresAtText.getText());
                    tableViewer.refresh();
                    HumanTaskCustomEditor.this.notifyFromText.setText("");
                    HumanTaskCustomEditor.this.notifyToText.setText("");
                    HumanTaskCustomEditor.this.notifyToGroupsText.setText("");
                    HumanTaskCustomEditor.this.notifyReplyToText.setText("");
                    HumanTaskCustomEditor.this.notifySubjectText.setText("");
                    HumanTaskCustomEditor.this.notifyBodyText.setText("");
                    HumanTaskCustomEditor.this.notifyTypeText.setText("");
                    HumanTaskCustomEditor.this.notifyExpiresAtText.setText("");
                }
            }
        });
        Button clearButton = new Button(composite, 0);
        clearButton.setText("Clear");
        clearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                HumanTaskCustomEditor.this.notifyFromText.setText("");
                HumanTaskCustomEditor.this.notifyToText.setText("");
                HumanTaskCustomEditor.this.notifyToGroupsText.setText("");
                HumanTaskCustomEditor.this.notifyReplyToText.setText("");
                HumanTaskCustomEditor.this.notifySubjectText.setText("");
                HumanTaskCustomEditor.this.notifyBodyText.setText("");
                HumanTaskCustomEditor.this.notifyTypeText.setText("");
                HumanTaskCustomEditor.this.notifyExpiresAtText.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                HumanTaskCustomEditor.this.notifyFromText.setText("");
                HumanTaskCustomEditor.this.notifyToText.setText("");
                HumanTaskCustomEditor.this.notifyToGroupsText.setText("");
                HumanTaskCustomEditor.this.notifyReplyToText.setText("");
                HumanTaskCustomEditor.this.notifySubjectText.setText("");
                HumanTaskCustomEditor.this.notifyBodyText.setText("");
                HumanTaskCustomEditor.this.notifyTypeText.setText("");
                HumanTaskCustomEditor.this.notifyExpiresAtText.setText("");
            }
        });
    }

    @Override
    protected Work updateValue(Work value) {
        WorkImpl work = new WorkImpl();
        work.setName("Human Task");
        work.setParameter("TaskName", (Object)this.nameText.getText());
        work.setParameter("ActorId", (Object)this.actorText.getText());
        work.setParameter("GroupId", (Object)this.groupText.getText());
        work.setParameter("Comment", (Object)this.commentText.getText());
        work.setParameter("Priority", (Object)this.priorityText.getText());
        work.setParameter("Skippable", (Object)String.valueOf(this.skippableButton.getSelection()));
        String content = this.contentText.getText();
        work.setParameter("Content", (Object)(content.trim().length() == 0 ? null : content));
        work.setParameter("CreatedBy", (Object)this.createdByText.getText());
        work.setParameter("Locale", (Object)this.localeText.getText());
        if (!this.reassignments.isEmpty()) {
            StringBuffer notStartedReassignments = new StringBuffer();
            StringBuffer notCompletedReassignments = new StringBuffer();
            for (Reassignment reassign : this.reassignments) {
                if ("not-started".equalsIgnoreCase(reassign.getTypeAsString())) {
                    if (notStartedReassignments.length() > 0) {
                        notStartedReassignments.append(COMPONENT_SEPARATOR);
                    }
                    notStartedReassignments.append(reassign.toDataInput());
                    continue;
                }
                if (!"not-completed".equalsIgnoreCase(reassign.getTypeAsString())) continue;
                if (notCompletedReassignments.length() > 0) {
                    notCompletedReassignments.append(COMPONENT_SEPARATOR);
                }
                notCompletedReassignments.append(reassign.toDataInput());
            }
            if (notStartedReassignments.length() > 0) {
                work.setParameter("NotStartedReassign", (Object)notStartedReassignments.toString());
            }
            if (notCompletedReassignments.length() > 0) {
                work.setParameter("NotCompletedReassign", (Object)notCompletedReassignments.toString());
            }
        }
        if (!this.notifications.isEmpty()) {
            StringBuffer notStartedNotifications = new StringBuffer();
            StringBuffer notCompletedNotifications = new StringBuffer();
            for (Notification notification : this.notifications) {
                if ("not-started".equalsIgnoreCase(notification.getType())) {
                    if (notStartedNotifications.length() > 0) {
                        notStartedNotifications.append(COMPONENT_SEPARATOR);
                    }
                    notStartedNotifications.append(notification.toDataInput());
                    continue;
                }
                if (!"not-completed".equalsIgnoreCase(notification.getType())) continue;
                if (notCompletedNotifications.length() > 0) {
                    notCompletedNotifications.append(COMPONENT_SEPARATOR);
                }
                notCompletedNotifications.append(notification.toDataInput());
            }
            if (notStartedNotifications.length() > 0) {
                work.setParameter("NotStartedNotify", (Object)notStartedNotifications.toString());
            }
            if (notCompletedNotifications.length() > 0) {
                work.setParameter("NotCompletedNotify", (Object)notCompletedNotifications.toString());
            }
        }
        work.setParameterDefinitions(value.getParameterDefinitions());
        return work;
    }

    public Work getWork() {
        return (Work)this.getValue();
    }

    public void setWork(Work work) {
        this.setValue(work);
    }

    public void setWorkDefinition(WorkDefinition workDefinition) {
    }

    public boolean show() {
        int result = this.open();
        return result == 0;
    }

    private class Notification {
        private String expiresAt = "";
        private String from = "";
        private String to = "";
        private String toGroups = "";
        private String replyTo = "";
        private String subject = "";
        private String body = "";
        private String type = "";

        public Notification() {
        }

        public Notification(String dataInput, String type) {
            this.type = type;
            String[] components = dataInput.split(HumanTaskCustomEditor.ELEMENT_SEPARATOR);
            String actions = components[0].substring(1, components[0].length() - 1);
            String[] details = actions.split(HumanTaskCustomEditor.ATTRIBUTES_SEPARATOR_ESCAPED);
            Properties parameters = new Properties();
            String[] stringArray = details;
            int n = details.length;
            int n2 = 0;
            while (n2 < n) {
                String detail = stringArray[n2];
                String[] stringArray2 = KNOWN_KEYS;
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String knownKey = stringArray2[n4];
                    if (detail.startsWith(knownKey)) {
                        try {
                            parameters.put(knownKey, detail.substring(knownKey.length() + HumanTaskCustomEditor.KEY_VALUE_SEPARATOR.length()));
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            parameters.put(knownKey, "");
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            this.setFrom(parameters.getProperty("from", ""));
            this.setTo(parameters.getProperty("tousers", ""));
            this.setToGroups(parameters.getProperty("togroups", ""));
            this.setReplyTo(parameters.getProperty("replyTo", ""));
            this.setSubject(parameters.getProperty("subject", ""));
            this.setBody(parameters.getProperty("body", ""));
            this.expiresAt = components[1].substring(1, components[1].length() - 1);
        }

        public String getExpiresAt() {
            return this.expiresAt;
        }

        public void setExpiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String getReplyTo() {
            return this.replyTo;
        }

        public void setReplyTo(String replyTo) {
            this.replyTo = replyTo;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String toDataInput() {
            boolean separatorRequired = false;
            StringBuffer dataInput = new StringBuffer();
            dataInput.append("[");
            if (this.from != null && this.from.length() > 0) {
                dataInput.append("from:");
                dataInput.append(this.from);
                separatorRequired = true;
            }
            if (this.to != null && this.to.length() > 0) {
                if (separatorRequired) {
                    dataInput.append(HumanTaskCustomEditor.ATTRIBUTES_SEPARATOR);
                }
                dataInput.append("tousers:");
                dataInput.append(this.to);
                separatorRequired = true;
            }
            if (this.toGroups != null && this.toGroups.length() > 0) {
                if (separatorRequired) {
                    dataInput.append(HumanTaskCustomEditor.ATTRIBUTES_SEPARATOR);
                }
                dataInput.append("togroups:");
                dataInput.append(this.toGroups);
                separatorRequired = true;
            }
            if (this.replyTo != null && this.replyTo.length() > 0) {
                if (separatorRequired) {
                    dataInput.append(HumanTaskCustomEditor.ATTRIBUTES_SEPARATOR);
                }
                dataInput.append("replyTo:");
                dataInput.append(this.replyTo);
                separatorRequired = true;
            }
            if (this.subject != null && this.subject.length() > 0) {
                if (separatorRequired) {
                    dataInput.append(HumanTaskCustomEditor.ATTRIBUTES_SEPARATOR);
                }
                dataInput.append("subject:");
                dataInput.append(this.subject);
                separatorRequired = true;
            }
            if (this.body != null && this.body.length() > 0) {
                if (separatorRequired) {
                    dataInput.append(HumanTaskCustomEditor.ATTRIBUTES_SEPARATOR);
                }
                dataInput.append("body:");
                dataInput.append(this.body);
                separatorRequired = true;
            }
            dataInput.append("]");
            dataInput.append(HumanTaskCustomEditor.ELEMENT_SEPARATOR);
            dataInput.append("[");
            dataInput.append(this.expiresAt);
            dataInput.append("]");
            return dataInput.toString();
        }

        public void setToGroups(String toGroups) {
            this.toGroups = toGroups;
        }

        public String getToGroups() {
            return this.toGroups;
        }
    }

    private class NotificationsContentProvider
    implements IStructuredContentProvider {
        private NotificationsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return HumanTaskCustomEditor.this.notifications.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class NotificationsEditing
    extends EditingSupport {
        private TextCellEditor cellEditor;

        public NotificationsEditing(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.cellEditor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            return ((Notification)element).getSubject();
        }

        protected void setValue(Object element, Object value) {
            ((Notification)element).setSubject(value.toString());
            this.getViewer().update(element, null);
        }
    }

    private class NotificationsLabelProvider
    extends ColumnLabelProvider {
        private NotificationsLabelProvider() {
        }

        public String getText(Object element) {
            return ((Notification)element).getSubject();
        }
    }

    private class Reassignment {
        private String expiresAt = "";
        private String users = "";
        private String groups = "";
        private Integer type = 0;

        public Reassignment() {
        }

        public Reassignment(String dataInput, String type) {
            if ("not-started".equalsIgnoreCase(type)) {
                this.type = 0;
            } else if ("not-completed".equalsIgnoreCase(type)) {
                this.type = 1;
            }
            String[] components = dataInput.split(HumanTaskCustomEditor.ELEMENT_SEPARATOR);
            String actions = components[0].substring(1, components[0].length() - 1);
            String[] details = actions.split(HumanTaskCustomEditor.ATTRIBUTES_SEPARATOR_ESCAPED);
            if (details[0].toLowerCase().startsWith("users")) {
                this.users = details[0].substring(6);
            } else if (details[0].toLowerCase().startsWith("groups")) {
                this.groups = details[0].substring(7);
            }
            if (details.length > 1) {
                if (details[1].toLowerCase().startsWith("users")) {
                    this.users = details[1].substring(6);
                } else if (details[1].toLowerCase().startsWith("groups")) {
                    this.groups = details[1].substring(7);
                }
            }
            this.expiresAt = components[1].substring(1, components[1].length() - 1);
        }

        public String getExpiresAt() {
            return this.expiresAt;
        }

        public void setExpiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
        }

        public String getUsers() {
            return this.users;
        }

        public void setUsers(String users) {
            this.users = users;
        }

        public String getGroups() {
            return this.groups;
        }

        public void setGroups(String groups) {
            this.groups = groups;
        }

        public String toDataInput() {
            boolean separatorRequired = false;
            StringBuffer dataInput = new StringBuffer();
            dataInput.append("[");
            if (this.users != null && this.users.length() > 0) {
                dataInput.append("users:");
                dataInput.append(this.users);
                separatorRequired = true;
            }
            if (this.groups != null && this.groups.length() > 0) {
                if (separatorRequired) {
                    dataInput.append(HumanTaskCustomEditor.ATTRIBUTES_SEPARATOR);
                }
                dataInput.append("groups:");
                dataInput.append(this.groups);
            }
            dataInput.append("]");
            dataInput.append(HumanTaskCustomEditor.ELEMENT_SEPARATOR);
            dataInput.append("[");
            dataInput.append(this.expiresAt);
            dataInput.append("]");
            return dataInput.toString();
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return this.type;
        }

        public String getTypeAsString() {
            if (this.type == 0) {
                return "not-started";
            }
            if (this.type == 1) {
                return "not-completed";
            }
            return null;
        }
    }

    private class ReassignmentContentProvider
    implements IStructuredContentProvider {
        private ReassignmentContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return HumanTaskCustomEditor.this.reassignments.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ReassignmentExpiresAtEditing
    extends EditingSupport {
        private TextCellEditor cellEditor;

        public ReassignmentExpiresAtEditing(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.cellEditor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            return ((Reassignment)element).getExpiresAt();
        }

        protected void setValue(Object element, Object value) {
            ((Reassignment)element).setExpiresAt(value.toString());
            this.getViewer().update(element, null);
        }
    }

    private class ReassignmentExpiresAtLabelProvider
    extends ColumnLabelProvider {
        private ReassignmentExpiresAtLabelProvider() {
        }

        public String getText(Object element) {
            return ((Reassignment)element).getExpiresAt();
        }
    }

    private class ReassignmentGroupsEditing
    extends EditingSupport {
        private TextCellEditor cellEditor;

        public ReassignmentGroupsEditing(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.cellEditor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            return ((Reassignment)element).getGroups();
        }

        protected void setValue(Object element, Object value) {
            ((Reassignment)element).setGroups(value.toString());
            this.getViewer().update(element, null);
        }
    }

    private class ReassignmentGroupsLabelProvider
    extends ColumnLabelProvider {
        private ReassignmentGroupsLabelProvider() {
        }

        public String getText(Object element) {
            return ((Reassignment)element).getGroups();
        }
    }

    private class ReassignmentTypeEditing
    extends EditingSupport {
        private ComboBoxCellEditor cellEditor;

        public ReassignmentTypeEditing(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.cellEditor = new ComboBoxCellEditor((Composite)viewer.getTable(), new String[]{"not-started", "not-completed"});
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            return ((Reassignment)element).getType();
        }

        protected void setValue(Object element, Object value) {
            ((Reassignment)element).setType((Integer)value);
            this.getViewer().update(element, null);
        }
    }

    private class ReassignmentTypeLabelProvider
    extends ColumnLabelProvider {
        private ReassignmentTypeLabelProvider() {
        }

        public String getText(Object element) {
            return ((Reassignment)element).getTypeAsString();
        }
    }

    private class ReassignmentUsersEditing
    extends EditingSupport {
        private TextCellEditor cellEditor;

        public ReassignmentUsersEditing(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.cellEditor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            return ((Reassignment)element).getUsers();
        }

        protected void setValue(Object element, Object value) {
            ((Reassignment)element).setUsers(value.toString());
            this.getViewer().update(element, null);
        }
    }

    private class ReassignmentUsersLabelProvider
    extends ColumnLabelProvider {
        private ReassignmentUsersLabelProvider() {
        }

        public String getText(Object element) {
            return ((Reassignment)element).getUsers();
        }
    }
}

