/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.runtime.IRuntimeInstaller;

public abstract class AbstractRuntimeInstaller
implements IRuntimeInstaller {
    static Hashtable<String, AbstractRuntimeInstaller> installers;
    static Hashtable<String, ArtifactList> artifacts;
    public static final String KIE_RUNTIME_INSTALLER = "org.kie.eclipse.runtimeInstaller";
    public static Factory FACTORY;
    protected String id;
    protected String product;
    protected String version;
    protected String runtimeName;
    protected int priority;
    protected List<Repository> repositories;

    static {
        FACTORY = new Factory();
    }

    @Override
    public abstract String install(String var1, String var2, IProgressMonitor var3);

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getRuntimeName() {
        return this.runtimeName;
    }

    public void setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
    }

    public List<Repository> getRepositories() {
        if (this.repositories == null) {
            this.repositories = new ArrayList<Repository>();
        }
        return this.repositories;
    }

    public static class Artifact {
        String type;
        String name;
        String source;
        String target;

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }
    }

    public static class ArtifactList
    extends ArrayList<Artifact> {
        String id;
        String name;
        List<Artifact> artifacts = new ArrayList<Artifact>();

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<Artifact> getArtifacts() {
            return this.artifacts;
        }
    }

    public static class Factory {
        protected Factory() {
        }

        public AbstractRuntimeInstaller getInstaller(String runtimeId) {
            this.createInstallers();
            return installers.get(runtimeId);
        }

        public Collection<? extends IRuntimeInstaller> createInstallers() {
            if (installers == null) {
                installers = new Hashtable();
                try {
                    IConfigurationElement[] config;
                    IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(AbstractRuntimeInstaller.KIE_RUNTIME_INSTALLER);
                    int n = config.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int n3;
                        IConfigurationElement e = iConfigurationElementArray[n2];
                        if ("installer".equals(e.getName())) {
                            Object o = e.createExecutableExtension("class");
                            if (o instanceof AbstractRuntimeInstaller) {
                                AbstractRuntimeInstaller installer = (AbstractRuntimeInstaller)o;
                                installer.id = e.getAttribute("id");
                                installer.product = e.getAttribute("product");
                                installer.version = e.getAttribute("version");
                                installer.runtimeName = e.getAttribute("runtimeName");
                                IConfigurationElement[] iConfigurationElementArray2 = e.getChildren("repository");
                                int n4 = iConfigurationElementArray2.length;
                                n3 = 0;
                                while (n3 < n4) {
                                    IConfigurationElement r = iConfigurationElementArray2[n3];
                                    Repository repository = new Repository();
                                    repository.url = r.getAttribute("url");
                                    repository.type = r.getAttribute("type");
                                    repository.source = r.getAttribute("source");
                                    repository.target = r.getAttribute("target");
                                    repository.artifactsId = r.getAttribute("artifacts");
                                    installer.getRepositories().add(repository);
                                    ++n3;
                                }
                                try {
                                    installer.priority = Integer.getInteger(e.getAttribute("priority"));
                                }
                                catch (Exception ex) {
                                    installer.priority = 1;
                                }
                                AbstractRuntimeInstaller oldInstaller = installers.get(installer.version);
                                if (oldInstaller == null || installer.priority > oldInstaller.priority) {
                                    installers.put(installer.version, installer);
                                }
                            }
                        } else if ("artifacts".equals(e.getName())) {
                            ArtifactList artifactList = new ArtifactList();
                            artifactList.id = e.getAttribute("id");
                            artifactList.name = e.getAttribute("name");
                            IConfigurationElement[] iConfigurationElementArray3 = e.getChildren("artifact");
                            n3 = iConfigurationElementArray3.length;
                            int n5 = 0;
                            while (n5 < n3) {
                                IConfigurationElement a = iConfigurationElementArray3[n5];
                                Artifact artifact = new Artifact();
                                artifact.type = a.getAttribute("type");
                                artifact.name = a.getAttribute("name");
                                artifact.source = a.getAttribute("source");
                                artifact.target = a.getAttribute("target");
                                artifactList.artifacts.add(artifact);
                                ++n5;
                            }
                            if (artifacts == null) {
                                artifacts = new Hashtable();
                            }
                            artifacts.put(artifactList.id, artifactList);
                        }
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)ex.getMessage());
                }
            }
            return installers.values();
        }
    }

    public static class Repository {
        protected String url;
        protected String type;
        protected String source;
        protected String target;
        protected String artifactsId;

        public String getUrl() {
            return this.url;
        }

        public String getType() {
            return this.type;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }

        public ArtifactList getArtifactList() {
            FACTORY.createInstallers();
            return artifacts.get(this.artifactsId);
        }

        public List<Artifact> getArtifacts() {
            ArtifactList al = this.getArtifactList();
            return al.getArtifacts();
        }
    }
}

