/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.project;

import com.eclipsesource.json.JsonObject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.undo.MoveProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.kie.eclipse.navigator.KieNavigatorContentRoot;
import org.kie.eclipse.navigator.view.IKieNavigatorView;
import org.kie.eclipse.navigator.view.KieNavigatorContentProvider;
import org.kie.eclipse.navigator.view.KieNavigatorLabelProvider;
import org.kie.eclipse.navigator.view.actions.dialogs.KieRequestDialogTextField;
import org.kie.eclipse.navigator.view.content.IContentNode;
import org.kie.eclipse.navigator.view.content.RepositoryNode;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.KieProjectHandler;

public class ConvertToKieProjectAction
implements IObjectActionDelegate {
    private IJavaProject project;
    protected IStatus errorStatus;
    private Shell shell;

    public void run(IAction action) {
        if (this.project != null && this.project.exists()) {
            this.errorStatus = null;
            this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            KieDestinationSelectionDialog dlg = new KieDestinationSelectionDialog(this.shell, this.project.getProject());
            if (dlg.open() != 0) {
                return;
            }
            RepositoryNode rn = dlg.getDestination();
            if (rn == null) {
                return;
            }
            boolean completed = this.performMove(this.project.getProject(), rn, dlg.getProperties());
            if (!completed) {
                return;
            }
            if (this.errorStatus != null) {
                ErrorDialog.openError((Shell)this.shell, (String)"Error", null, (IStatus)this.errorStatus);
                this.errorStatus = null;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structured;
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
            IJavaProject javaProject;
            Object element = structured.getFirstElement();
            if (element instanceof IJavaProject) {
                this.project = (IJavaProject)element;
            } else if (element instanceof IProject && (javaProject = JavaCore.create((IProject)((IProject)element))) != null && javaProject.exists()) {
                this.project = javaProject;
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    boolean performMove(final IProject project, final RepositoryNode rn, final JsonObject properties) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(final IProgressMonitor monitor) {
                Repository repository = (Repository)rn.getHandler().getResource();
                File file = new File(String.valueOf(repository.getWorkTree().getAbsolutePath()) + File.separator + project.getName());
                URI newLocation = file.toURI();
                final MoveProjectOperation op = new MoveProjectOperation(project, newLocation, "Moving Project");
                try {
                    final IOperationHistory history = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                    final IAdaptable info = WorkspaceUndoUtil.getUIInfoAdapter((Shell)ConvertToKieProjectAction.this.shell);
                    history.execute((IUndoableOperation)op, monitor, info);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                KieProjectHandler kieProject = new KieProjectHandler((IKieRepositoryHandler)rn.getHandler(), project.getName());
                                kieProject.setProperties(properties);
                                rn.getHandler().getDelegate().createProject((IKieProjectHandler)kieProject);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                try {
                                    history.undoOperation((IUndoableOperation)op, monitor, info);
                                }
                                catch (ExecutionException e1) {
                                    e1.printStackTrace();
                                }
                                ConvertToKieProjectAction.this.displayError(e.getMessage());
                            }
                        }
                    });
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof CoreException) {
                        ConvertToKieProjectAction.this.errorStatus = ((CoreException)e.getCause()).getStatus();
                    }
                    e.printStackTrace();
                    ConvertToKieProjectAction.this.displayError(e.getMessage());
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.shell).run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.displayError(NLS.bind((String)"Internal error: {0}", (Object)e.getTargetException().getMessage()));
            return false;
        }
        return true;
    }

    void displayError(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)ConvertToKieProjectAction.this.shell, (String)"Error", (String)message);
            }
        });
    }

    class KieDestinationSelectionDialog
    extends ElementTreeSelectionDialog
    implements IKieNavigatorView {
        IProject project;
        JsonObject properties;
        KieRequestDialogTextField description;
        KieRequestDialogTextField groupId;
        KieRequestDialogTextField version;

        public KieDestinationSelectionDialog(Shell parent, final IProject project) {
            super(parent, (ILabelProvider)new KieNavigatorLabelProvider(), (ITreeContentProvider)new KieNavigatorContentProvider());
            this.properties = new JsonObject();
            this.project = project;
            this.setTitle("Convert to Kie Project");
            this.setMessage("Select a destination Repository for the Project \"" + project.getName() + "\"");
            this.setAllowMultiple(false);
            this.setInput(new KieNavigatorContentRoot(this));
            this.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection.length == 1 && selection[0] instanceof RepositoryNode) {
                        RepositoryNode rn = (RepositoryNode)selection[0];
                        rn.load();
                        if (rn.getChildren() == null) {
                            return new Status(4, "org.kie.eclipse.navigator", "Repository is not available");
                        }
                        if (!(rn.getHandler().getResource() instanceof Repository)) {
                            return new Status(4, "org.kie.eclipse.navigator", "Repository is not available");
                        }
                        for (IContentNode<?> cn : rn.getChildren()) {
                            if (!cn.getName().equals(project.getName())) continue;
                            return new Status(4, "org.kie.eclipse.navigator", "Repository already has a Project named \"" + project.getName() + "\"");
                        }
                        return new Status(0, "org.kie.eclipse.navigator", "");
                    }
                    return new Status(4, "org.kie.eclipse.navigator", "Please select a destination Repository");
                }
            });
        }

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText("Enter Project properties:");
            label.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            this.properties.add("name", this.project.getName());
            this.description = new KieRequestDialogTextField(composite, "Description:", "", this.properties, "description");
            this.groupId = new KieRequestDialogTextField(composite, "Group ID:", "", this.properties, "groupId");
            this.version = new KieRequestDialogTextField(composite, "Version:", "", this.properties, "version");
            return control;
        }

        @Override
        public void refresh(Object element) {
            this.getTreeViewer().refresh(element);
        }

        @Override
        public void setProperty(String key, String value) {
            this.getTreeViewer().setData(key, (Object)value);
        }

        @Override
        public String getProperty(String key) {
            Object value = this.getTreeViewer().getData(key);
            if (value != null) {
                return value.toString();
            }
            return null;
        }

        public JsonObject getProperties() {
            return this.properties;
        }

        public RepositoryNode getDestination() {
            Object[] result = this.getResult();
            if (result.length == 1 && result[0] instanceof RepositoryNode) {
                RepositoryNode rn = (RepositoryNode)result[0];
                return rn;
            }
            return null;
        }
    }
}

