/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor;

import java.util.Collections;
import java.util.Iterator;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ConditionalBranchDescr;
import org.drools.compiler.lang.descr.NamedConsequenceDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.Consequence;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintParser;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseResult;

public class NamedConsequenceVisitor {
    final RuleContext context;
    final PackageModel packageModel;

    public NamedConsequenceVisitor(RuleContext context, PackageModel packageModel) {
        this.context = context;
        this.packageModel = packageModel;
    }

    public void visit(NamedConsequenceDescr descr) {
        MethodCallExpr executeCallDSL = this.onDSL(descr);
        this.context.addExpression((Expression)executeCallDSL);
    }

    public void visit(ConditionalBranchDescr desc) {
        PatternDescr patternRelated = (PatternDescr)this.getReferringPatternDescr(desc, (AndDescr)this.context.parentDesc);
        Class<?> patternRelatedClass = DrlxParseUtil.getClassFromContext(this.context.getTypeResolver(), patternRelated.getObjectType());
        MethodCallExpr whenBlock = this.whenThenDSL(desc, patternRelated, patternRelatedClass, "D.when", null);
        this.recurseAmongElseBranch(patternRelatedClass, patternRelated, whenBlock, desc.getElseBranch());
    }

    private void recurseAmongElseBranch(Class<?> patternType, PatternDescr patternRelated, MethodCallExpr parentMethodExpr, ConditionalBranchDescr branch) {
        if (branch != null) {
            MethodCallExpr elseWhenBlock = this.whenThenDSL(branch, patternRelated, patternType, "elseWhen", parentMethodExpr);
            this.recurseAmongElseBranch(patternType, patternRelated, elseWhenBlock, branch.getElseBranch());
        } else {
            this.context.addExpression((Expression)parentMethodExpr);
        }
    }

    private MethodCallExpr whenThenDSL(ConditionalBranchDescr desc, PatternDescr patternRelated, Class<?> patternType, String callMethod, MethodCallExpr parentExpression) {
        MethodCallExpr when = new MethodCallExpr((Expression)parentExpression, callMethod);
        String condition = desc.getCondition().toString();
        if (!condition.equals("true")) {
            when.addArgument((Expression)new StringLiteralExpr(this.context.getConditionId(patternType, condition)));
            when.addArgument(this.context.getVarExpr(patternRelated.getIdentifier()));
            DrlxParseResult parseResult = new ConstraintParser(this.context, this.packageModel).drlxParse(patternType, patternRelated.getIdentifier(), condition);
            parseResult.accept(parseSuccess -> {
                MethodCallExpr cfr_ignored_0 = (MethodCallExpr)when.addArgument(DrlxParseUtil.generateLambdaWithoutParameters(Collections.emptySortedSet(), parseSuccess.getExpr()));
            });
        }
        MethodCallExpr then = new MethodCallExpr((Expression)when, "then");
        MethodCallExpr rhs = this.onDSL(desc.getConsequence());
        then.addArgument((Expression)rhs);
        return then;
    }

    private BaseDescr getReferringPatternDescr(ConditionalBranchDescr desc, AndDescr parent) {
        BaseDescr b;
        BaseDescr patternRelated = null;
        Iterator iterator = parent.getDescrs().iterator();
        while (iterator.hasNext() && !(b = (BaseDescr)iterator.next()).equals(desc)) {
            patternRelated = b;
        }
        return patternRelated;
    }

    private MethodCallExpr onDSL(NamedConsequenceDescr namedConsequence) {
        String namedConsequenceString = this.context.getNamedConsequences().get(namedConsequence.getName());
        BlockStmt ruleVariablesBlock = new BlockStmt();
        ModelGenerator.createVariables(this.context.getKbuilder(), ruleVariablesBlock, this.packageModel, this.context);
        return new Consequence(this.context).createCall(null, namedConsequenceString, ruleVariablesBlock, namedConsequence.isBreaking());
    }
}

