/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.DebugUtil;
import org.drools.eclipse.debug.ObjectWrapper;
import org.drools.eclipse.debug.VariableWrapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ILogicalStructureTypeDelegate;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class ProcessInstanceLogicalStructureDelegate
implements ILogicalStructureTypeDelegate {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean providesLogicalStructure(IValue value) {
        if (!(value instanceof IJavaObject)) {
            return false;
        }
        IJavaObject javaValue = (IJavaObject)value;
        try {
            IJavaType type = javaValue.getJavaType();
            if (!(type instanceof IJavaClassType)) {
                return false;
            }
            IJavaClassType classType = (IJavaClassType)type;
            IJavaInterfaceType[] interfaceTypes = classType.getAllInterfaces();
            int i = 0;
            while (true) {
                if (i >= interfaceTypes.length) {
                    return false;
                }
                if ("org.jbpm.process.instance.ProcessInstance".equals(interfaceTypes[i].getName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (DebugException e) {
            DroolsEclipsePlugin.log(e);
            return false;
        }
    }

    public IValue getLogicalStructure(IValue value) throws CoreException {
        if (!(value instanceof IJavaObject)) {
            return null;
        }
        IJavaObject javaValue = (IJavaObject)value;
        if (!this.providesLogicalStructure(value)) {
            return null;
        }
        ArrayList<VariableWrapper> variables = new ArrayList<VariableWrapper>();
        IJavaValue id = null;
        IJavaValue processId = null;
        IJavaValue processName = null;
        IVariable[] vars = value.getVariables();
        int j = 0;
        while (j < vars.length) {
            IVariable var = vars[j];
            if ("id".equals(var.getName())) {
                id = (IJavaValue)var.getValue();
            } else if ("process".equals(var.getName())) {
                IJavaValue process = (IJavaValue)var.getValue();
                IVariable[] vars2 = process.getVariables();
                int k = 0;
                while (k < vars2.length) {
                    IVariable var2 = vars2[k];
                    if ("id".equals(var2.getName())) {
                        processId = (IJavaValue)var2.getValue();
                    } else if ("name".equals(var2.getName())) {
                        processName = (IJavaValue)var2.getValue();
                    }
                    ++k;
                }
            }
            ++j;
        }
        variables.add(new VariableWrapper("id", id));
        variables.add(new VariableWrapper("processName", processName));
        variables.add(new VariableWrapper("processId", processId));
        IJavaArray nodeInstances = (IJavaArray)DebugUtil.getValueByExpression("return getNodeInstances().toArray();", value);
        ArrayList<VariableWrapper> nodeInstancesResult = new ArrayList<VariableWrapper>();
        IJavaValue[] javaVals = nodeInstances.getValues();
        int i = 0;
        while (i < javaVals.length) {
            IJavaValue nodeInstance = javaVals[i];
            id = null;
            vars = nodeInstance.getVariables();
            int j2 = 0;
            while (j2 < vars.length) {
                IVariable var = vars[j2];
                if ("id".equals(var.getName())) {
                    id = (IJavaValue)var.getValue();
                }
                ++j2;
            }
            nodeInstancesResult.add(new VariableWrapper("[" + id.getValueString() + "]", nodeInstance));
            ++i;
        }
        variables.add(new VariableWrapper("nodeInstances", (IJavaValue)new ObjectWrapper((IJavaObject)nodeInstances, nodeInstancesResult.toArray(new IJavaVariable[nodeInstancesResult.size()]))));
        return new ObjectWrapper(javaValue, variables.toArray(new IJavaVariable[variables.size()]));
    }
}

