/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.exceptionHandler;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.eclipse.flow.common.view.property.MapItemDialog;
import org.drools.eclipse.flow.ruleflow.view.property.action.ActionCompletionProcessor;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowGlobalsDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowImportsDialog;
import org.drools.eclipse.util.ArrayUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;

public class ExceptionHandlerDialog
extends EditBeanDialog<ActionExceptionHandler>
implements MapItemDialog<String> {
    private static final String[] DIALECTS = new String[]{"mvel", "java"};
    private String key;
    private Text nameText;
    private Text faultVariableText;
    private WorkflowProcess process;
    private TabFolder tabFolder;
    private SourceViewer actionViewer;
    private Combo dialectCombo;
    private ActionCompletionProcessor completionProcessor;

    public ExceptionHandlerDialog(Shell parentShell, WorkflowProcess process) {
        super(parentShell, "Edit Exception Handler");
        this.process = process;
    }

    @Override
    protected Point getInitialSize() {
        return new Point(400, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name: ");
        this.nameText = new Text(composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameText.setLayoutData((Object)gridData);
        if (this.key != null) {
            this.nameText.setText(this.key);
            this.nameText.setEditable(false);
        }
        nameLabel = new Label(composite, 0);
        nameLabel.setText("FaultVariable: ");
        this.faultVariableText = new Text(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.faultVariableText.setLayoutData((Object)gridData);
        String faultVariable = ((ActionExceptionHandler)this.getValue()).getFaultVariable();
        this.faultVariableText.setText(faultVariable == null ? "" : faultVariable);
        Composite top = new Composite(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        top.setLayoutData((Object)gd);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        top.setLayout((Layout)gridLayout);
        Label label = new Label(top, 0);
        label.setText("Dialect:");
        this.createDialectCombo(top);
        Button importButton = new Button(top, 8);
        importButton.setText("Imports ...");
        importButton.setFont(JFaceResources.getDialogFont());
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExceptionHandlerDialog.this.importButtonPressed();
            }
        });
        Button globalButton = new Button(top, 8);
        globalButton.setText("Globals ...");
        globalButton.setFont(JFaceResources.getDialogFont());
        globalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExceptionHandlerDialog.this.globalButtonPressed();
            }
        });
        this.tabFolder = new TabFolder(composite, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gd);
        TabItem textEditorTab = new TabItem(this.tabFolder, 0);
        textEditorTab.setText("Textual Editor");
        textEditorTab.setControl(this.createTextualEditor((Composite)this.tabFolder));
        return composite;
    }

    private Control createTextualEditor(Composite parent) {
        this.actionViewer = new SourceViewer(parent, null, 2048);
        this.actionViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            @Override
            public IReconciler getReconciler(ISourceViewer sourceViewer) {
                return null;
            }

            @Override
            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant assistant = new ContentAssistant();
                ExceptionHandlerDialog.this.completionProcessor = new ActionCompletionProcessor(ExceptionHandlerDialog.this.process);
                assistant.setContentAssistProcessor((IContentAssistProcessor)ExceptionHandlerDialog.this.completionProcessor, "__dftl_partition_content_type");
                assistant.setProposalPopupOrientation(10);
                return assistant;
            }
        });
        this.completionProcessor.setDialect(this.dialectCombo.getItem(this.dialectCombo.getSelectionIndex()));
        DroolsAction action = ((ActionExceptionHandler)this.getValue()).getAction();
        String value = null;
        if (action instanceof DroolsConsequenceAction) {
            value = ((DroolsConsequenceAction)action).getConsequence();
        }
        if (value == null) {
            value = "";
        }
        Document document = new Document(value);
        this.actionViewer.setDocument((IDocument)document);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.actionViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ' && e.stateMask == 262144) {
                    ExceptionHandlerDialog.this.actionViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.actionViewer.getControl();
    }

    private Control createDialectCombo(Composite parent) {
        String dialect;
        int found;
        this.dialectCombo = new Combo(parent, 12);
        this.dialectCombo.setItems(DIALECTS);
        DroolsAction action = ((ActionExceptionHandler)this.getValue()).getAction();
        int index = 0;
        if (action instanceof DroolsConsequenceAction && (found = ArrayUtils.indexOf(DIALECTS, dialect = ((DroolsConsequenceAction)action).getDialect())) >= 0) {
            index = found;
        }
        this.dialectCombo.select(index);
        this.dialectCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ExceptionHandlerDialog.this.completionProcessor.setDialect(ExceptionHandlerDialog.this.dialectCombo.getItem(ExceptionHandlerDialog.this.dialectCombo.getSelectionIndex()));
            }

            public void widgetSelected(SelectionEvent e) {
                ExceptionHandlerDialog.this.completionProcessor.setDialect(ExceptionHandlerDialog.this.dialectCombo.getItem(ExceptionHandlerDialog.this.dialectCombo.getSelectionIndex()));
            }
        });
        return this.dialectCombo;
    }

    private DroolsConsequenceAction getAction() {
        return new DroolsConsequenceAction(this.dialectCombo.getItem(this.dialectCombo.getSelectionIndex()), this.actionViewer.getDocument().get());
    }

    private void importButtonPressed() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                RuleFlowImportsDialog dialog = new RuleFlowImportsDialog(ExceptionHandlerDialog.this.getShell(), ExceptionHandlerDialog.this.process);
                dialog.create();
                int code = dialog.open();
                if (code != 1) {
                    List<String> imports = dialog.getImports();
                    ExceptionHandlerDialog.this.process.setImports(new HashSet<String>(imports));
                    ExceptionHandlerDialog.this.completionProcessor.reset();
                }
            }
        };
        r.run();
    }

    private void globalButtonPressed() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                RuleFlowGlobalsDialog dialog = new RuleFlowGlobalsDialog(ExceptionHandlerDialog.this.getShell(), ExceptionHandlerDialog.this.process);
                dialog.create();
                int code = dialog.open();
                if (code != 1) {
                    Map<String, String> globals = dialog.getGlobals();
                    ExceptionHandlerDialog.this.process.setGlobals(globals);
                    ExceptionHandlerDialog.this.completionProcessor.reset();
                }
            }
        };
        r.run();
    }

    @Override
    protected ActionExceptionHandler updateValue(ActionExceptionHandler value) {
        this.key = this.nameText.getText();
        if (this.key.length() == 0) {
            throw new IllegalArgumentException("Name should not be empty.");
        }
        value.setFaultVariable(this.faultVariableText.getText());
        if (this.tabFolder.getSelectionIndex() == 0) {
            value.setAction((DroolsAction)this.getAction());
        }
        return value;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }
}

