/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.action;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.compiler.xml.processes.RuleFlowMigrator;
import org.jbpm.eclipse.JBPMEclipsePlugin;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;

public class GenerateForms
implements IObjectActionDelegate {
    private IFile file;
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        if (this.file != null && this.file.exists()) {
            try {
                this.generateForms();
            }
            catch (Throwable t) {
                JBPMEclipsePlugin.log(t);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        IStructuredSelection structured;
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1 && (element = structured.getFirstElement()) instanceof IFile) {
            this.file = (IFile)element;
        }
    }

    public void generateForms() {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.file.getProject());
            if (javaProject == null || !javaProject.exists()) {
                return;
            }
            InputStreamReader isr = new InputStreamReader(((File)this.file).getContents());
            KnowledgeBuilderConfigurationImpl configuration = new KnowledgeBuilderConfigurationImpl();
            SemanticModules modules = configuration.getSemanticModules();
            modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
            modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
            modules.addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
            XmlProcessReader xmlReader = new XmlProcessReader(modules, Thread.currentThread().getContextClassLoader());
            String xml = RuleFlowMigrator.convertReaderToString((Reader)isr);
            StringReader reader = new StringReader(xml);
            List processes = xmlReader.read((Reader)reader);
            if (processes != null && processes.size() == 1) {
                final RuleFlowProcess process = (RuleFlowProcess)processes.get(0);
                ArrayList<HumanTaskNode> result = new ArrayList<HumanTaskNode>();
                GenerateForms.processNodes(process.getNodes(), result);
                final HashMap<String, TaskDef> tasks = new HashMap<String, TaskDef>();
                for (HumanTaskNode node : result) {
                    VariableScope variableScope;
                    String taskName = (String)node.getWork().getParameter("TaskName");
                    if (taskName == null) break;
                    TaskDef task = (TaskDef)tasks.get(taskName);
                    if (task == null) {
                        task = new TaskDef(taskName);
                        tasks.put(taskName, task);
                    }
                    for (Map.Entry entry : node.getInMappings().entrySet()) {
                        if (task.getInputParams().get(entry.getKey()) != null || (variableScope = (VariableScope)node.resolveContext("VariableScope", entry.getValue())) == null) continue;
                        task.getInputParams().put((String)entry.getKey(), variableScope.findVariable((String)entry.getValue()).getType().getStringType());
                    }
                    for (Map.Entry entry : node.getOutMappings().entrySet()) {
                        if (task.getOutputParams().get(entry.getKey()) != null || (variableScope = (VariableScope)node.resolveContext("VariableScope", entry.getValue())) == null || "outcome".equals(entry.getKey())) continue;
                        task.getOutputParams().put((String)entry.getKey(), variableScope.findVariable((String)entry.getValue()).getType().getStringType());
                    }
                }
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) throws CoreException {
                        try {
                            IFolder folder = GenerateForms.this.file.getProject().getFolder("src/main/resources");
                            for (TaskDef task : tasks.values()) {
                                String fileName = String.valueOf(task.getTaskName()) + ".ftl";
                                String output = "<html>\n<body>\n<h2>" + task.getTaskName() + "</h2>\n" + "<hr>\n" + "<#if task.descriptions[0]??>\n" + "Description: ${task.descriptions[0].text}<BR/>\n" + "</#if>\n";
                                for (String input : task.getInputParams().keySet()) {
                                    output = String.valueOf(output) + input + ": ${" + input + "}<BR/>\n";
                                }
                                output = String.valueOf(output) + "<form action=\"complete\" method=\"POST\" enctype=\"multipart/form-data\">\n";
                                for (String outputP : task.getOutputParams().keySet()) {
                                    output = String.valueOf(output) + outputP + ": <input type=\"text\" name=\"" + outputP + "\" /><BR/>\n";
                                }
                                output = String.valueOf(output) + "<BR/>\n<input type=\"submit\" name=\"outcome\" value=\"Complete\"/>\n</form>\n</body>\n</html>";
                                IFile file = folder.getFile(fileName);
                                if (!file.exists()) {
                                    file.create((InputStream)new ByteArrayInputStream(output.getBytes()), true, monitor);
                                    continue;
                                }
                                file.setContents((InputStream)new ByteArrayInputStream(output.getBytes()), true, false, monitor);
                            }
                            String fileName = String.valueOf(process.getId()) + ".ftl";
                            String output = "<html>\n<body>\n<h2>" + process.getName() + "</h2>\n" + "<hr>\n" + "<form action=\"complete\" method=\"POST\" enctype=\"multipart/form-data\">\n";
                            for (Variable variable : process.getVariableScope().getVariables()) {
                                if (!"String".equals(variable.getType().getStringType())) continue;
                                output = String.valueOf(output) + variable.getName() + ": <input type=\"text\" name=\"" + variable.getName() + "\" /><BR/>\n";
                            }
                            output = String.valueOf(output) + "<input type=\"submit\" value=\"Complete\"/>\n</form>\n</body>\n</html>";
                            IFile file = folder.getFile(fileName);
                            if (!file.exists()) {
                                file.create((InputStream)new ByteArrayInputStream(output.getBytes()), true, monitor);
                            } else {
                                file.setContents((InputStream)new ByteArrayInputStream(output.getBytes()), true, false, monitor);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(this.targetPart.getSite().getShell()).run(false, true, (IRunnableWithProgress)op);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void processNodes(Node[] nodes, List<HumanTaskNode> result) {
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node instanceof HumanTaskNode) {
                result.add((HumanTaskNode)node);
            } else if (node instanceof NodeContainer) {
                GenerateForms.processNodes(((NodeContainer)node).getNodes(), result);
            }
            ++n2;
        }
    }

    private class TaskDef {
        private String taskName;
        private Map<String, String> inputParams = new HashMap<String, String>();
        private Map<String, String> outputParams = new HashMap<String, String>();

        public TaskDef(String taskName) {
            this.taskName = taskName;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public Map<String, String> getInputParams() {
            return this.inputParams;
        }

        public Map<String, String> getOutputParams() {
            return this.outputParams;
        }
    }
}

