/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.drools.core.util.ClassUtils;
import org.drools.mvel.parser.ast.expr.DrlNameExpr;
import org.drools.mvel.parser.ast.visitor.DrlGenericVisitor;
import org.drools.mvel.parser.printer.PrintUtil;
import org.drools.mvelcompiler.MvelCompilerException;
import org.drools.mvelcompiler.ast.AssignExprT;
import org.drools.mvelcompiler.ast.ExpressionStmtT;
import org.drools.mvelcompiler.ast.FieldToAccessorTExpr;
import org.drools.mvelcompiler.ast.SimpleNameTExpr;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.ast.UnalteredTypedExpression;
import org.drools.mvelcompiler.ast.VariableDeclaratorTExpr;
import org.drools.mvelcompiler.context.Declaration;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LHSPhase
implements DrlGenericVisitor<TypedExpression, Context> {
    Logger logger = LoggerFactory.getLogger(LHSPhase.class);
    private final MvelCompilerContext mvelCompilerContext;
    private final Optional<TypedExpression> rhs;

    public LHSPhase(MvelCompilerContext mvelCompilerContext, Optional<TypedExpression> rhs) {
        this.mvelCompilerContext = mvelCompilerContext;
        this.rhs = rhs;
    }

    public TypedExpression invoke(Statement statement) {
        this.logger.debug("LHS phase on:\t\t" + PrintUtil.printConstraint((Node)statement));
        Context ctx = new Context();
        TypedExpression typedExpression = (TypedExpression)statement.accept((GenericVisitor)this, (Object)ctx);
        if (typedExpression == null) {
            throw new MvelCompilerException("Type check of " + PrintUtil.printConstraint((Node)statement) + " failed.");
        }
        this.logger.debug("LHS phase completed");
        return typedExpression;
    }

    public TypedExpression visit(DrlNameExpr n, Context arg) {
        this.logger.debug("DrlNameExpr:\t\t" + PrintUtil.printConstraint((Node)n));
        String variableName = PrintUtil.printConstraint((Node)n);
        Optional<Declaration> declaration = this.mvelCompilerContext.findDeclarations(variableName);
        return declaration.map(d -> new SimpleNameTExpr(n.getNameAsString(), d.getClazz())).orElseGet(() -> {
            this.mvelCompilerContext.addCreatedDeclaration(variableName, this.getRHSType());
            return new VariableDeclaratorTExpr((Node)n, variableName, this.getRHSType(), this.rhs);
        });
    }

    public TypedExpression visit(FieldAccessExpr n, Context arg) {
        this.logger.debug("FieldAccessExpr:\t\t" + PrintUtil.printConstraint((Node)n));
        if (this.parentIsExpressionStmt(n)) {
            return this.rhsOrError();
        }
        TypedExpression scope = (TypedExpression)n.getScope().accept((GenericVisitor)this, (Object)arg);
        n.getName().accept((GenericVisitor)this, (Object)arg);
        Class<?> setterArgumentType = this.getRHSType();
        return this.tryParseItAsSetter(n, scope, setterArgumentType).orElse(new UnalteredTypedExpression((Node)n));
    }

    private Optional<TypedExpression> tryParseItAsSetter(FieldAccessExpr n, TypedExpression scope, Class<?> setterArgumentType) {
        return scope.getType().flatMap(scopeType -> {
            String setterName = PrintUtil.printConstraint((Node)n.getName());
            Optional<Method> optAccessor = Optional.ofNullable(ClassUtils.getSetter((Class)((Class)scopeType), (String)setterName, (Class[])new Class[]{setterArgumentType}));
            List arguments = this.rhs.map(Collections::singletonList).orElse(Collections.emptyList());
            return optAccessor.map(accessor -> new FieldToAccessorTExpr(scope, (Method)accessor, arguments));
        });
    }

    public TypedExpression visit(MethodCallExpr n, Context arg) {
        this.logger.debug("MethodCallExpr:\t\t" + PrintUtil.printConstraint((Node)n));
        return this.rhsOrError();
    }

    public TypedExpression visit(VariableDeclarationExpr n, Context arg) {
        this.logger.debug("VariableDeclarationExpr:\t\t" + PrintUtil.printConstraint((Node)n));
        return (TypedExpression)((VariableDeclarator)n.getVariables().iterator().next()).accept((GenericVisitor)this, (Object)arg);
    }

    public TypedExpression visit(VariableDeclarator n, Context arg) {
        this.logger.debug("VariableDeclarator:\t\t" + PrintUtil.printConstraint((Node)n));
        String variableName = n.getName().asString();
        Class<?> type = this.getRHSorLHSType(n);
        this.mvelCompilerContext.addDeclaration(variableName, type);
        return new VariableDeclaratorTExpr((Node)n, variableName, type, this.rhs);
    }

    public TypedExpression visit(ExpressionStmt n, Context arg) {
        this.logger.debug("ExpressionStmt:\t\t" + PrintUtil.printConstraint((Node)n));
        Optional<Object> expression = Optional.ofNullable(n.getExpression().accept((GenericVisitor)this, (Object)arg));
        return new ExpressionStmtT(expression.orElseGet(this::rhsOrError));
    }

    public TypedExpression visit(AssignExpr n, Context arg) {
        this.logger.debug("AssignExpr:\t\t" + PrintUtil.printConstraint((Node)n));
        TypedExpression target = (TypedExpression)n.getTarget().accept((GenericVisitor)this, (Object)arg);
        if (target instanceof FieldToAccessorTExpr) {
            return target;
        }
        if (target instanceof VariableDeclaratorTExpr) {
            return target;
        }
        return new AssignExprT(n.getOperator(), target, this.rhsOrNull());
    }

    public TypedExpression visit(IfStmt n, Context arg) {
        return new UnalteredTypedExpression((Node)n);
    }

    private TypedExpression rhsOrNull() {
        return this.rhs.orElse(null);
    }

    private TypedExpression rhsOrError() {
        return this.rhs.orElseThrow(() -> new MvelCompilerException("RHS not found, need a valid expression"));
    }

    private boolean parentIsExpressionStmt(FieldAccessExpr n) {
        return n.getParentNode().filter(p -> p instanceof ExpressionStmt).isPresent();
    }

    private Class<?> getRHSType() {
        return (Class)this.rhs.flatMap(TypedExpression::getType).orElseThrow(() -> new MvelCompilerException("RHS doesn't have a type"));
    }

    private Class<?> getRHSorLHSType(VariableDeclarator n) {
        return (Class)this.rhs.flatMap(TypedExpression::getType).orElseGet(() -> this.mvelCompilerContext.resolveType(n.getType().asString()));
    }

    static class Context {
        Context() {
        }
    }
}

