/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.wizard.project;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jbpm.eclipse.JBPMEclipsePlugin;
import org.jbpm.eclipse.util.JBPMRuntime;
import org.jbpm.eclipse.util.JBPMRuntimeManager;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.utils.FileUtils;
import org.kie.eclipse.wizard.project.AbstractKieEmptyProjectWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieOnlineExampleProjectWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieProjectStartWizardPage;
import org.kie.eclipse.wizard.project.AbstractKieProjectWizard;
import org.kie.eclipse.wizard.project.IKieProjectWizardPage;
import org.kie.eclipse.wizard.project.IKieSampleFilesProjectWizardPage;

public class NewJBPMProjectWizard
extends AbstractKieProjectWizard {
    private EmptyJBPMProjectWizardPage emptyProjectPage;
    private SampleJBPMProjectWizardPage sampleFilesProjectPage;

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = JBPMEclipsePlugin.getImageDescriptor("icons/jbpm-large.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    protected void createOutputLocation(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        String target = "bin";
        if (this.startPage.getInitialProjectContent() == 0) {
            target = this.emptyProjectPage.shouldCreateMavenProject() ? "target/classes" : "bin";
        } else if (this.startPage.getInitialProjectContent() == 2) {
            target = this.sampleFilesProjectPage.shouldCreateMavenProject() ? "target/classes" : "bin";
        }
        IFolder folder = project.getProject().getFolder(target);
        FileUtils.createFolder((IFolder)folder, (IProgressMonitor)monitor);
        IPath path = folder.getFullPath();
        project.setOutputLocation(path, null);
    }

    protected void setClasspath(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        super.setClasspath(project, monitor);
        if (this.startPage.getInitialProjectContent() == 0) {
            if (!this.emptyProjectPage.shouldCreateMavenProject()) {
                FileUtils.addJUnitLibrary((IJavaProject)project, (IProgressMonitor)monitor);
            }
        } else if (this.startPage.getInitialProjectContent() == 2 && !this.sampleFilesProjectPage.shouldCreateMavenProject() && this.sampleFilesProjectPage.shouldCreateJUnitFile()) {
            FileUtils.addJUnitLibrary((IJavaProject)project, (IProgressMonitor)monitor);
        }
    }

    protected void addSourceFolders(IJavaProject project, IProgressMonitor monitor) throws JavaModelException, CoreException {
        if (this.startPage.getInitialProjectContent() != 1) {
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            list.addAll(Arrays.asList(project.getRawClasspath()));
            this.addSourceFolder(project, list, "src/main/java", monitor);
            this.addSourceFolder(project, list, "src/main/resources", monitor);
            project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), null);
        }
    }

    protected void createInitialContent(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException, JavaModelException, IOException {
        if (this.startPage.getInitialProjectContent() == 0) {
            this.createDefaultPackages(javaProject, monitor);
        } else if (this.startPage.getInitialProjectContent() == 2) {
            String exampleType = this.sampleFilesProjectPage.getSampleType();
            this.createProcess(javaProject, monitor, exampleType);
            if (this.sampleFilesProjectPage.shouldCreateJUnitFile()) {
                this.createProcessSampleJUnit(javaProject, exampleType, monitor);
            }
        }
        super.createInitialContent(javaProject, monitor);
        this.createLoggerFile(javaProject, monitor);
    }

    private void createDefaultPackages(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        IFolder folder = project.getProject().getFolder("src/main/java/com/sample");
        FileUtils.createFolder((IFolder)folder, (IProgressMonitor)monitor);
        folder = project.getProject().getFolder("src/main/resources/com/sample");
        FileUtils.createFolder((IFolder)folder, (IProgressMonitor)monitor);
    }

    private void createLoggerFile(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        String fileName = "org/jbpm/eclipse/wizard/project/logback-test.xml.template";
        IFolder folder = project.getProject().getFolder("src/main/resources");
        FileUtils.createFolder((IFolder)folder, (IProgressMonitor)monitor);
        IFile file = folder.getFile("logback-test.xml");
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
        if (!file.exists()) {
            file.create(inputstream, true, monitor);
        } else {
            file.setContents(inputstream, true, false, monitor);
        }
    }

    private void createProcess(IJavaProject project, IProgressMonitor monitor, String exampleType) throws CoreException, IOException {
        String fileName = "org/jbpm/eclipse/wizard/project/" + exampleType + ".bpmn.template";
        IFolder folder = null;
        folder = project.getProject().getFolder("src/main/resources/com/sample");
        FileUtils.createFolder((IFolder)folder, (IProgressMonitor)monitor);
        IFile file = folder.getFile("sample.bpmn");
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
        if (!file.exists()) {
            file.create(inputstream, true, monitor);
        } else {
            file.setContents(inputstream, true, false, monitor);
        }
        fileName = "org/jbpm/eclipse/wizard/project/ProcessMain-" + exampleType + ".java";
        IRuntime runtime = this.startPage.getRuntime();
        fileName = runtime.getVersion().getMajor() == 5 ? String.valueOf(fileName) + ".v5.template" : String.valueOf(fileName) + ".template";
        folder = project.getProject().getFolder("src/main/java");
        IPackageFragmentRoot packageFragmentRoot = project.getPackageFragmentRoot((IResource)folder);
        IPackageFragment packageFragment = packageFragmentRoot.createPackageFragment("com.sample", true, monitor);
        inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
        packageFragment.createCompilationUnit("ProcessMain.java", new String(FileUtils.readStream((InputStream)inputstream)), true, monitor);
        if (runtime.getVersion().getMajor() == 5 && "advanced".equals(exampleType)) {
            folder = project.getProject().getFolder("src/main/resources/META-INF");
            FileUtils.createFolder((IFolder)folder, (IProgressMonitor)monitor);
            inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/jbpm/eclipse/wizard/project/ProcessLauncher-advanced-persistence.xml.template");
            file = folder.getFile("persistence.xml");
            if (!file.exists()) {
                file.create(inputstream, true, monitor);
            } else {
                file.setContents(inputstream, true, false, monitor);
            }
        }
    }

    private void createProcessSampleJUnit(IJavaProject project, String exampleType, IProgressMonitor monitor) throws JavaModelException, IOException {
        String s = "org/jbpm/eclipse/wizard/project/ProcessJUnit-" + exampleType + ".java";
        IRuntime runtime = this.startPage.getRuntime();
        s = runtime.getVersion().getMajor() == 5 ? String.valueOf(s) + ".v5.template" : String.valueOf(s) + ".template";
        IFolder folder = project.getProject().getFolder("src/main/java");
        IPackageFragmentRoot packageFragmentRoot = project.getPackageFragmentRoot((IResource)folder);
        IPackageFragment packageFragment = packageFragmentRoot.createPackageFragment("com.sample", true, monitor);
        InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(s);
        packageFragment.createCompilationUnit("ProcessTest.java", new String(FileUtils.readStream((InputStream)inputstream)), true, monitor);
    }

    protected void createKJarArtifacts(IJavaProject project, IProgressMonitor monitor) {
        try {
            String fileName = "org/jbpm/eclipse/wizard/project/kmodule.xml.template";
            IFolder folder = project.getProject().getFolder("src/main/resources/META-INF");
            FileUtils.createFolder((IFolder)folder, (IProgressMonitor)monitor);
            IFile file = folder.getFile("kmodule.xml");
            InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
            if (!file.exists()) {
                file.create(inputstream, true, monitor);
            } else {
                file.setContents(inputstream, true, false, monitor);
            }
            String projectName = project.getProject().getName();
            String groupId = "com.sample";
            String artifactId = projectName;
            String version = "1.0.0-SNAPSHOT";
            FileUtils.createProjectFile((IJavaProject)project, (IProgressMonitor)monitor, (InputStream)FileUtils.generatePomProperties((String)groupId, (String)artifactId, (String)version), (String)"src/main/resources/META-INF/maven", (String)"pom.properties");
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    protected void createMavenArtifacts(IJavaProject project, IProgressMonitor monitor) {
        try {
            String projectName = project.getProject().getName();
            String runtimeVersion = this.startPage.getRuntime().getVersion().toString();
            String groupId = "com.sample";
            String artifactId = projectName;
            String version = "1.0.0-SNAPSHOT";
            if (this.startPage.getInitialProjectContent() == 2) {
                groupId = this.sampleFilesProjectPage.getPomGroupId();
                artifactId = this.sampleFilesProjectPage.getPomArtifactId();
                version = this.sampleFilesProjectPage.getPomVersion();
            } else if (this.startPage.getInitialProjectContent() == 0) {
                groupId = this.emptyProjectPage.getPomGroupId();
                artifactId = this.emptyProjectPage.getPomArtifactId();
                version = this.emptyProjectPage.getPomVersion();
            }
            FileUtils.createProjectFile((IJavaProject)project, (IProgressMonitor)monitor, (InputStream)FileUtils.generatePomProperties((String)groupId, (String)artifactId, (String)version), (String)"src/main/resources/META-INF/maven", (String)"pom.properties");
            String fileName = "org/jbpm/eclipse/wizard/project/maven-pom.xml.template";
            InputStream inputstream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
            FileUtils.createProjectFile((IJavaProject)project, (IProgressMonitor)monitor, (InputStream)FileUtils.generatePom((InputStream)inputstream, (String)runtimeVersion, (String)groupId, (String)artifactId, (String)version), null, (String)"pom.xml");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected IKieProjectWizardPage createStartPage(String pageId) {
        return new AbstractKieProjectStartWizardPage(pageId){

            public String getTitle() {
                return "Create New jBPM Project";
            }
        };
    }

    protected IKieProjectWizardPage createEmptyProjectPage(String pageId) {
        this.emptyProjectPage = new EmptyJBPMProjectWizardPage("NewEmptProjectPage");
        return this.emptyProjectPage;
    }

    protected IKieProjectWizardPage createSampleFilesProjectPage(String pageId) {
        this.sampleFilesProjectPage = new SampleJBPMProjectWizardPage("NewSampleFilesProjectPage");
        return this.sampleFilesProjectPage;
    }

    protected IKieProjectWizardPage createOnlineExampleProjectPage(String pageId) {
        return new AbstractKieOnlineExampleProjectWizardPage("NewOnlineExampleProjectPage"){

            public String getTitle() {
                return "Create jBPM Projects from Online Examples";
            }

            public String getDescription() {
                return "Select jBPM Example Projects";
            }

            public IRuntimeManager getRuntimeManager() {
                return JBPMRuntimeManager.getDefault();
            }

            public String getProductId() {
                return "jbpm";
            }
        };
    }

    class EmptyJBPMProjectWizardPage
    extends AbstractKieEmptyProjectWizardPage
    implements IKieSampleFilesProjectWizardPage {
        public EmptyJBPMProjectWizardPage(String pageName) {
            super(pageName);
            this.setTitle("Create New Empty jBPM Project");
            this.setDescription("Select the type of jBPM Project");
        }

        protected void createControls(Composite parent) {
        }

        public IRuntimeManager getRuntimeManager() {
            return JBPMRuntimeManager.getDefault();
        }

        protected IRuntime createRuntime() {
            return new JBPMRuntime();
        }

        public int showRuntimePreferenceDialog() {
            return PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.jbpm.eclipse.preferences.JBPMRuntimesPreferencePage", (String[])new String[]{"org.jbpm.eclipse.preferences.JBPMProjectPreferencePage"}, new HashMap()).open();
        }

        public String getProductName() {
            return "jBPM";
        }

        public String getProductId() {
            return "jbpm";
        }
    }

    class SampleJBPMProjectWizardPage
    extends EmptyJBPMProjectWizardPage {
        private Button simpleProcessButton;
        private Button advancedProcessButton;
        private Button addSampleJUnitTestCodeButton;
        private boolean addSampleJUnit;
        private String sampleType;

        public SampleJBPMProjectWizardPage(String pageName) {
            super(pageName);
            this.addSampleJUnit = false;
            this.sampleType = "simple";
            this.setTitle("Create New jBPM Project with Sample Files");
            this.setDescription("Select the samples to be included");
        }

        @Override
        protected void createControls(Composite parent) {
            this.simpleProcessButton = this.createRadioButton(parent, "Add a simple hello world process");
            this.simpleProcessButton.setSelection(true);
            this.simpleProcessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        SampleJBPMProjectWizardPage.this.sampleType = "simple";
                    }
                }
            });
            this.advancedProcessButton = this.createRadioButton(parent, "Add a more advanced process including human tasks and persistence");
            this.advancedProcessButton.setSelection(false);
            this.advancedProcessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.widget).getSelection()) {
                        SampleJBPMProjectWizardPage.this.sampleType = "advanced";
                    }
                }
            });
            this.addSampleJUnitTestCodeButton = this.createCheckBox(parent, "Also include a sample JUnit test for the process");
            this.addSampleJUnitTestCodeButton.setSelection(this.addSampleJUnit);
            this.addSampleJUnitTestCodeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SampleJBPMProjectWizardPage.this.addSampleJUnit = ((Button)e.widget).getSelection();
                }
            });
        }

        public String getSampleType() {
            return this.sampleType;
        }

        public boolean shouldCreateJUnitFile() {
            return this.addSampleJUnit;
        }
    }
}

