/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.agent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class TransformationUtil {
    private TransformationUtil() {
    }

    public static void removeAttribute(CtClass ctClass, String name) throws CannotCompileException, NotFoundException {
        TransformationUtil.removeField(ctClass, name);
    }

    public static void removeElement(CtClass ctClass, String name) throws CannotCompileException, NotFoundException {
        TransformationUtil.removeField(ctClass, name);
        TransformationUtil.updatePropOrder(ctClass, name);
    }

    public static void removeElementList(CtClass ctClass, String name) throws CannotCompileException, NotFoundException {
        TransformationUtil.removeListField(ctClass, name);
        TransformationUtil.updatePropOrder(ctClass, name);
    }

    private static void removeField(CtClass ctClass, String name) throws CannotCompileException, NotFoundException {
        CtField field = ctClass.getDeclaredField(name);
        ctClass.removeField(field);
        CtMethod getterMethod = ctClass.getDeclaredMethod(TransformationUtil.formatMethodName("get", name));
        getterMethod.setBody(null);
        CtMethod setterMethod = ctClass.getDeclaredMethod(TransformationUtil.formatMethodName("set", name));
        setterMethod.setBody("throw new UnsupportedOperationException();");
    }

    private static void removeListField(CtClass ctClass, String name) throws CannotCompileException, NotFoundException {
        CtField field = ctClass.getDeclaredField(name, "Ljava/util/List;");
        ctClass.removeField(field);
        CtMethod testMethod = ctClass.getDeclaredMethod(TransformationUtil.formatMethodName("has", name));
        testMethod.setBody("return false;");
        CtMethod getterMethod = ctClass.getDeclaredMethod(TransformationUtil.formatMethodName("get", name));
        getterMethod.setBody("throw new UnsupportedOperationException();");
    }

    private static void updatePropOrder(CtClass ctClass, String name) {
        ClassFile classFile = ctClass.getClassFile();
        AnnotationsAttribute annotations = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        Annotation xmlTypeAnnotation = annotations.getAnnotation("javax.xml.bind.annotation.XmlType");
        ArrayMemberValue propOrderValue = (ArrayMemberValue)xmlTypeAnnotation.getMemberValue("propOrder");
        TransformationUtil.removeValue(propOrderValue, name);
        annotations.addAnnotation(xmlTypeAnnotation);
    }

    private static void removeValue(ArrayMemberValue memberValue, String value) {
        ArrayList<MemberValue> values = new ArrayList<MemberValue>(Arrays.asList(memberValue.getValue()));
        boolean removed = false;
        Iterator it = values.iterator();
        while (it.hasNext()) {
            StringMemberValue stringValue = (StringMemberValue)it.next();
            if (!value.equals(stringValue.getValue())) continue;
            it.remove();
            removed = true;
        }
        if (!removed) {
            throw new RuntimeException(value + " not in " + values);
        }
        memberValue.setValue(values.toArray(new MemberValue[values.size()]));
    }

    private static String formatMethodName(String prefix, String name) {
        return prefix + name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

