/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import org.drools.eclipse.flow.common.view.datatype.editor.Editor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.FloatDataType;

public class FloatEditor
extends Composite
implements Editor {
    private Text text;

    public FloatEditor(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.text = new Text((Composite)this, 0);
    }

    @Override
    public void setDataType(DataType dataType) {
        if (!(dataType instanceof FloatDataType)) {
            throw new IllegalArgumentException("Illegal data type " + dataType);
        }
    }

    @Override
    public Object getValue() throws IllegalArgumentException {
        String valueString = this.text.getText();
        if ("".equals(valueString)) {
            return null;
        }
        try {
            return new Float(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The value " + valueString + " is not a valid float.");
        }
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.text.setText("");
        } else if (value instanceof Float) {
            this.text.setText(((Float)value).toString());
        } else {
            throw new IllegalArgumentException("Value must be a float: " + value);
        }
    }

    @Override
    public void reset() {
        this.text.setText("");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }
}

