/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.views;

import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorRepository;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.views.model.TreeObject;
import org.guvnor.tools.views.model.TreeParent;

public class RepositoryContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private TreeParent invisibleRoot;
    private DeferredTreeContentManager manager;
    private AbstractTreeViewer viewer;
    private String repUrl;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (v instanceof AbstractTreeViewer) {
            this.viewer = (AbstractTreeViewer)v;
            this.manager = new DeferredTreeContentManager((ITreeContentProvider)this, this.viewer);
        }
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent.equals(this.viewer)) {
            if (this.invisibleRoot == null) {
                this.initialize();
            }
            return this.getChildren(this.invisibleRoot);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof TreeObject) {
            return ((TreeObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent == this.invisibleRoot) {
            return this.invisibleRoot.getChildren();
        }
        if (parent instanceof TreeParent) {
            return this.manager.getChildren(parent);
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof TreeParent) {
            return this.manager.mayHaveChildren(parent);
        }
        return false;
    }

    private void initialize() {
        boolean shouldAdd = true;
        this.invisibleRoot = new TreeParent("", TreeObject.Type.NONE);
        List<GuvnorRepository> reps = Activator.getLocationManager().getRepositories();
        int i = 0;
        while (i < reps.size()) {
            shouldAdd = this.repUrl != null ? this.repUrl.equals(reps.get(i).getLocation()) : true;
            if (shouldAdd) {
                TreeParent p = new TreeParent(reps.get(i).getLocation(), TreeObject.Type.REPOSITORY);
                p.setGuvnorRepository(reps.get(i));
                ResourceProperties props = new ResourceProperties();
                props.setBase("");
                p.setResourceProps(props);
                this.invisibleRoot.addChild(p);
            }
            ++i;
        }
    }

    public void setRepositorySelection(String repUrl) {
        this.repUrl = repUrl;
    }
}

