/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.datasources.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.drools.model.datasources.PassiveDataStore;

public class SetDataStore<T>
implements PassiveDataStore<T> {
    private final Set<T> store = new HashSet<T>();

    public static <T> PassiveDataStore<T> storeOf(T ... items) {
        SetDataStore<T> dataStore = new SetDataStore<T>();
        for (T item : items) {
            dataStore.insert(item);
        }
        return dataStore;
    }

    @Override
    public void insert(T obj) {
        this.store.add(obj);
    }

    @Override
    public void update(T obj) {
        if (this.store.remove(obj)) {
            throw new RuntimeException(obj + " not present");
        }
        this.store.add(obj);
    }

    @Override
    public void delete(T obj) {
        this.store.remove(obj);
    }

    @Override
    public Collection<T> getObjects() {
        return this.store;
    }
}

