/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.drools.eclipse.reteoo.BaseVertex;

public class Row {
    private final int depth;
    private List<BaseVertex> vertices = new ArrayList<BaseVertex>();

    public Row(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void add(BaseVertex vertex) {
        this.vertices.add(vertex);
    }

    public List<BaseVertex> getVertices() {
        return this.vertices;
    }

    public boolean contains(BaseVertex vertex) {
        return this.vertices.contains(vertex);
    }

    public int getWidth() {
        return this.vertices.size();
    }

    public void optimize() {
        ArrayList<BaseVertex> sorted = new ArrayList<BaseVertex>(this.vertices);
        Collections.sort(sorted, new Comparator<BaseVertex>(){

            @Override
            public int compare(BaseVertex v1, BaseVertex v2) {
                int v2OutDegree;
                int v1OutDegree = v1.getSourceConnections().size();
                if (v1OutDegree < (v2OutDegree = v2.getSourceConnections().size())) {
                    return 1;
                }
                if (v1OutDegree > v2OutDegree) {
                    return -1;
                }
                return 0;
            }
        });
        LinkedList<BaseVertex> optimized = new LinkedList<BaseVertex>();
        boolean front = false;
        for (BaseVertex vertex : sorted) {
            if (front) {
                optimized.addFirst(vertex);
            } else {
                optimized.addLast(vertex);
            }
            boolean bl = front = !front;
        }
        this.vertices = optimized;
    }
}

