/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.properties;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.views.model.TreeObject;

public class RepositoryElementPropsDialog
extends TitleAreaDialog {
    private static final int INITIAL_WIDTH = 780;
    private static final int INITIAL_HEIGHT = 400;
    private TreeObject node;
    private Text unField;
    private Text pwField;

    public RepositoryElementPropsDialog(Shell parentShell, TreeObject node) {
        super(parentShell);
        super.setShellStyle(this.getShellStyle() | 0x10);
        this.node = node;
    }

    protected Control createDialogArea(Composite parent) {
        super.setTitle(Messages.getString("guvnor.repository.element"));
        super.setMessage(MessageFormat.format(Messages.getString("guvnor.resource.properties"), this.node.getName()));
        super.setTitleImage(Activator.getImageDescriptor("guvnor_rep_wizban.gif").createImage());
        TabFolder folder = new TabFolder(parent, 128);
        folder.setLayoutData((Object)new GridData(1808));
        TabItem tab = new TabItem(folder, 0);
        tab.setText(Messages.getString("properties.basic"));
        Composite composite = PlatformUtils.createComposite((Composite)folder, 2);
        tab.setControl((Control)composite);
        this.addElementProperties(composite);
        tab = new TabItem(folder, 0);
        tab.setText(Messages.getString("properties.security"));
        composite = PlatformUtils.createComposite((Composite)folder, 2);
        tab.setControl((Control)composite);
        this.addSecurityProperties(composite);
        return super.createDialogArea(parent);
    }

    private void addElementProperties(Composite composite) {
        IPropertySource ps = (IPropertySource)this.node.getAdapter(IPropertySource.class);
        if (ps == null) {
            return;
        }
        IPropertyDescriptor[] desc = ps.getPropertyDescriptors();
        int i = 0;
        while (i < desc.length) {
            if (desc[i] instanceof TextPropertyDescriptor) {
                TextPropertyDescriptor oneDesc = (TextPropertyDescriptor)desc[i];
                new Label(composite, 0).setText(MessageFormat.format(Messages.getString("guvnor.resource.property"), oneDesc.getDisplayName()));
                String val = ps.getPropertyValue(oneDesc.getId()) != null ? (String)ps.getPropertyValue(oneDesc.getId()) : "";
                new Label(composite, 0).setText(val);
            }
            ++i;
        }
    }

    private void addSecurityProperties(Composite composite) {
        new Label(composite, 0).setText(Messages.getString("user.name"));
        this.unField = new Text(composite, 2060);
        this.unField.setLayoutData((Object)new GridData(768));
        this.unField.setEditable(false);
        this.unField.setBackground(Display.getDefault().getSystemColor(22));
        new Label(composite, 0).setText(Messages.getString("password"));
        this.pwField = new Text(composite, 4196364);
        this.pwField.setLayoutData((Object)new GridData(768));
        this.pwField.setEditable(false);
        this.pwField.setBackground(Display.getDefault().getSystemColor(22));
        this.populateSecuritySettings();
    }

    private void populateSecuritySettings() {
        try {
            String pw;
            Map info = Platform.getAuthorizationInfo((URL)new URL(this.node.getGuvnorRepository().getLocation()), (String)"", (String)"basic");
            if (info == null) {
                return;
            }
            String un = (String)info.get("username");
            if (un != null) {
                this.unField.setText(un);
            }
            if ((pw = (String)info.get("password")) != null) {
                this.pwField.setText(pw);
            }
        }
        catch (MalformedURLException e) {
            Activator.getDefault().writeLog(4, e.getMessage(), e);
        }
    }

    protected Point getInitialSize() {
        return new Point(780, 400);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("guvnor.resource.properties.title"));
    }
}

