/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.server.jbpm770;

import java.io.IOException;
import org.kie.eclipse.server.KieServiceDelegate;
import org.kie.eclipse.server.jbpm770.JobFailedException;

public class Requester {
    private final KieServiceDelegate kieService;

    public Requester(KieServiceDelegate kieService) {
        this.kieService = kieService;
    }

    public void run(String title, Action action) throws IOException, JobFailedException {
        String jobId = null;
        try {
            jobId = action.execute();
            String status = this.kieService.getJobStatus(jobId, title);
            if (status == null) {
                throw new IOException(String.valueOf(title) + " has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException(String.valueOf(title) + " has failed with status " + status);
            }
        }
        catch (InterruptedException e) {
            throw new JobFailedException(jobId, e);
        }
    }

    public static interface Action {
        public String execute() throws IOException;
    }
}

