/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.extended;

import java.math.BigDecimal;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class OddFunction
extends BaseFEELFunction {
    public static final OddFunction INSTANCE = new OddFunction();
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);

    OddFunction() {
        super("odd");
    }

    public FEELFnResult<Boolean> invoke(@ParameterName(value="number") BigDecimal number) {
        if (number == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "number", "cannot be null"));
        }
        if (number.remainder(BigDecimal.ONE).signum() != 0) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "number", "cannot have non-zero fractional part"));
        }
        return FEELFnResult.ofResult(BigDecimal.ZERO.compareTo(number.remainder(TWO)) != 0);
    }
}

