/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.extended;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.List;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.runtime.functions.extended.SqrtFunction;
import org.kie.dmn.feel.util.EvalHelper;

public class StddevFunction
extends BaseFEELFunction {
    public static final StddevFunction INSTANCE = new StddevFunction();

    StddevFunction() {
        super("stddev");
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="list") List<?> list) {
        if (list == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "the list cannot be null"));
        }
        int n = list.size();
        BigDecimal[] numbers = new BigDecimal[n];
        for (int i = 0; i < n; ++i) {
            BigDecimal val = EvalHelper.getBigDecimalOrNull(list.get(i));
            if (val == null) {
                return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "an element in the list is not suitable for the stddev"));
            }
            numbers[i] = val;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (int i = 0; i < n; ++i) {
            total = total.add(numbers[i]);
        }
        BigDecimal mean = total.divide(BigDecimal.valueOf(n), MathContext.DECIMAL128);
        total = BigDecimal.ZERO;
        for (int i = 0; i < n; ++i) {
            BigDecimal distanceSquared = numbers[i].subtract(mean).pow(2, MathContext.DECIMAL128);
            total = total.add(distanceSquared);
        }
        mean = total.divide(BigDecimal.valueOf(n - 1), MathContext.DECIMAL128);
        return FEELFnResult.ofResult(SqrtFunction.sqrt(mean));
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="list") Object sole) {
        if (sole == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "n", "the single value list cannot be null"));
        }
        return FEELFnResult.ofResult(BigDecimal.ZERO);
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="n") Object[] list) {
        if (list == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "n", "the single value list cannot be null"));
        }
        return this.invoke(Arrays.asList(list));
    }
}

