/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.rule;

import java.io.IOException;
import java.io.InputStream;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.wizard.rule.DRLGenerator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewRulePackagePage
extends WizardNewFileCreationPage {
    private static final int TYPE_RULE = 1;
    private static final int TYPE_PACKAGE = 0;
    private IWorkbench workbench;
    private Combo ruleFileType;
    private Button expander;
    private Button function;
    private Text packageName;

    public NewRulePackagePage(IWorkbench workbench, IStructuredSelection selection) {
        super("createDRLFilePage", selection);
        this.setTitle("New Rules File");
        this.setDescription("Create a new rules file (drl)");
        this.workbench = workbench;
    }

    protected void createAdvancedControls(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.setControl((Control)container);
        this.createType(container);
        this.createDSL(container);
        this.createFunctions(container);
        this.createPackageName(container);
        super.createAdvancedControls(parent);
    }

    protected boolean validatePage() {
        return super.validatePage() && this.validate();
    }

    private void createPackageName(Composite container) {
        Label pack = new Label(container, 0);
        pack.setText("Rule package name:");
        pack.setLayoutData((Object)new GridData(128));
        pack.setFont(this.getFont());
        this.packageName = new Text(container, 2048);
        this.packageName.setLayoutData((Object)new GridData(768));
        this.packageName.setToolTipText("Rules require a namespace.");
        this.packageName.setFont(this.getFont());
        this.packageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewRulePackagePage.this.setPageComplete(NewRulePackagePage.this.validatePage());
            }
        });
    }

    private void createFunctions(Composite container) {
        Label func = new Label(container, 0);
        func.setText("Use functions:");
        func.setLayoutData((Object)new GridData(128));
        func.setFont(this.getFont());
        this.function = new Button(container, 32);
        this.function.setSelection(false);
        this.function.setLayoutData((Object)new GridData(32));
        this.function.setToolTipText("Functions are methods you embed in your rule source.");
    }

    private void createDSL(Composite container) {
        Label exp = new Label(container, 0);
        exp.setText("Use a DSL:");
        exp.setLayoutData((Object)new GridData(128));
        exp.setFont(this.getFont());
        this.expander = new Button(container, 32);
        this.expander.setSelection(false);
        this.expander.setLayoutData((Object)new GridData(32));
        this.expander.setToolTipText("Domain Specific Language: allows you to create your own domain specific languages\n for use in rules.");
    }

    private void createType(Composite container) {
        Label type = new Label(container, 0);
        type.setText("Type of rule resource:");
        type.setFont(this.getFont());
        type.setLayoutData((Object)new GridData(128));
        this.ruleFileType = new Combo(container, 8);
        this.ruleFileType.add("New DRL (rule package)", 0);
        this.ruleFileType.add("New Rule (individual rule)", 1);
        this.ruleFileType.select(0);
        this.ruleFileType.setLayoutData((Object)new GridData(768));
        this.ruleFileType.setFont(this.getFont());
    }

    public boolean finish() {
        IFile newFile;
        String extension;
        if (!this.validate()) {
            return false;
        }
        String fileName = this.getFileName();
        String string = extension = this.expander.getSelection() ? ".dslr" : ".drl";
        if (!fileName.endsWith(extension)) {
            this.setFileName(String.valueOf(fileName) + extension);
        }
        if ((newFile = this.createNewFile()) == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            DroolsEclipsePlugin.log(e);
            return false;
        }
        return true;
    }

    private boolean validate() {
        if (this.packageName.getText() == null || this.packageName.getText().equals("")) {
            this.setErrorMessage("You must provide a rule package name");
            return false;
        }
        return true;
    }

    protected InputStream getInitialContents() {
        try {
            DRLGenerator gen = new DRLGenerator();
            if (this.ruleFileType.getSelectionIndex() == 1) {
                InputStream template = this.getTemplate("org/drools/eclipse/wizard/rule/new_rule.drl.template");
                return gen.generateRule(this.packageName.getText(), template);
            }
            InputStream template = this.getTemplate("org/drools/eclipse/wizard/rule/new_package.drl.template");
            return gen.generatePackage(this.packageName.getText(), this.function.getSelection(), this.expander.getSelection(), template);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private InputStream getTemplate(String templatePath) throws IOException {
        return DroolsEclipsePlugin.getDefault().getBundle().getResource(templatePath).openStream();
    }
}

