/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.jbpm.process.audit.event.AuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@SequenceGenerator(name="variableInstanceLogIdSeq", sequenceName="VAR_INST_LOG_ID_SEQ", allocationSize=1)
public class VariableInstanceLog
implements Serializable,
AuditEvent,
org.kie.api.runtime.manager.audit.VariableInstanceLog {
    private static final Logger logger = LoggerFactory.getLogger(VariableInstanceLog.class);
    private static final long serialVersionUID = 510L;
    @Transient
    private final int VARIABLE_LOG_LENGTH = Integer.parseInt(System.getProperty("org.jbpm.var.log.length", "255"));
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="variableInstanceLogIdSeq")
    private long id;
    private long processInstanceId;
    private String processId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="log_date")
    private Date date;
    private String variableInstanceId;
    private String variableId;
    private String value;
    private String oldValue;
    private String externalId;

    public VariableInstanceLog() {
    }

    public VariableInstanceLog(long processInstanceId, String processId, String variableInstanceId, String variableId, String value, String oldValue) {
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.variableInstanceId = variableInstanceId;
        this.variableId = variableId;
        this.setValue(value);
        this.setOldValue(oldValue);
        this.date = new Date();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getVariableInstanceId() {
        return this.variableInstanceId;
    }

    public void setVariableInstanceId(String variableInstanceId) {
        this.variableInstanceId = variableInstanceId;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value != null && value.length() > this.VARIABLE_LOG_LENGTH) {
            value = value.substring(0, this.VARIABLE_LOG_LENGTH);
            logger.warn("Variable content was trimmed as it was too long (more than {} characters)", (Object)this.VARIABLE_LOG_LENGTH);
        }
        this.value = value;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        if (oldValue != null && oldValue.length() > this.VARIABLE_LOG_LENGTH) {
            oldValue = oldValue.substring(0, this.VARIABLE_LOG_LENGTH);
            logger.warn("Variable content was trimmed as it was too long (more than {} characters)", (Object)this.VARIABLE_LOG_LENGTH);
        }
        this.oldValue = oldValue;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String domainId) {
        this.externalId = domainId;
    }

    public String toString() {
        return "Change variable '" + this.processId + "#" + this.variableId + "' to '" + this.value + "' [" + this.processInstanceId + "#" + this.variableInstanceId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (int)this.id;
        result = 31 * result + (this.processId == null ? 0 : this.processId.hashCode());
        result = 31 * result + (int)this.processInstanceId;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.oldValue == null ? 0 : this.oldValue.hashCode());
        result = 31 * result + (this.variableId == null ? 0 : this.variableId.hashCode());
        result = 31 * result + (this.variableInstanceId == null ? 0 : this.variableInstanceId.hashCode());
        result = 31 * result + (this.externalId == null ? 0 : this.externalId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableInstanceLog other = (VariableInstanceLog)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        if (this.processInstanceId != other.processInstanceId) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.oldValue == null ? other.oldValue != null : !this.oldValue.equals(other.oldValue)) {
            return false;
        }
        if (this.variableId == null ? other.variableId != null : !this.variableId.equals(other.variableId)) {
            return false;
        }
        if (this.variableInstanceId == null ? other.variableInstanceId != null : !this.variableInstanceId.equals(other.variableInstanceId)) {
            return false;
        }
        return !(this.externalId == null ? other.externalId != null : !this.externalId.equals(other.externalId));
    }
}

