/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.dialogs;

import com.eclipsesource.json.JsonObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.view.actions.dialogs.IKieRequestValidator;

public abstract class AbstractKieRequestDialog
extends TitleAreaDialog {
    protected JsonObject properties = new JsonObject();
    protected Button okButton;
    protected Composite errorComposite;
    protected Label errorText;
    protected IKieRequestValidator validator;
    private String title;

    protected abstract void createFields(Composite var1);

    public AbstractKieRequestDialog(Shell shell, String title, IKieRequestValidator validator) {
        super(shell);
        this.validator = validator;
        this.title = title;
        this.setHelpAvailable(true);
    }

    public JsonObject getResult() {
        return this.properties;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.title);
        this.validate();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setFont(parent.getFont());
        this.createFields(composite);
        return parentComposite;
    }

    protected Control createHelpControl(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.errorComposite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        this.errorComposite.setLayoutData((Object)gd);
        this.errorComposite.setLayout((Layout)new GridLayout(2, false));
        Label errorImage = new Label(this.errorComposite, 0);
        errorImage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        errorImage.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        this.errorText = new Label(this.errorComposite, 0);
        gd = new GridData(4, 0x1000000, true, false);
        this.errorText.setLayoutData((Object)gd);
        this.errorText.setText("");
        return this.errorComposite;
    }

    public void setErrorMessage(String newErrorMessage) {
        if (this.errorComposite != null && !this.errorComposite.isDisposed()) {
            if (newErrorMessage == null || newErrorMessage.isEmpty()) {
                this.errorComposite.setVisible(false);
                ((GridData)this.errorComposite.getLayoutData()).exclude = true;
                this.errorText.setText("");
            } else {
                this.errorComposite.setVisible(true);
                ((GridData)this.errorComposite.getLayoutData()).exclude = false;
                this.errorText.setText(newErrorMessage);
            }
            this.errorText.getParent().getParent().layout();
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
        }
        return button;
    }

    protected void validate() {
        String msg = null;
        if (this.validator != null && (msg = this.validator.isValid(this.properties)) != null) {
            this.setErrorMessage(msg);
            this.setDialogComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setDialogComplete(true);
        }
    }

    protected void setDialogComplete(boolean value) {
        this.okButton.setEnabled(value);
    }
}

