/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.model.v1_1.BusinessKnowledgeModel;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.Decision;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.model.v1_1.InformationRequirement;
import org.kie.dmn.model.v1_1.KnowledgeRequirement;
import org.kie.dmn.model.v1_1.NamedElement;

public abstract class DMNBaseNode
implements DMNNode {
    private NamedElement source;
    private Map<String, DMNNode> dependencies = new LinkedHashMap<String, DMNNode>();
    private Map<String, QName> importAliases = new HashMap<String, QName>();

    public DMNBaseNode() {
    }

    public DMNBaseNode(NamedElement source) {
        this.source = source;
    }

    public abstract DMNType getType();

    public String getId() {
        return this.source != null ? this.source.getId() : null;
    }

    public String getName() {
        return this.source != null ? this.source.getName() : null;
    }

    private Optional<Definitions> getParentDefinitions() {
        if (this.source != null) {
            DMNModelInstrumentedBase parent = this.source.getParent();
            while (!(parent instanceof Definitions)) {
                if (parent == null) {
                    return Optional.empty();
                }
                parent = parent.getParent();
            }
            return Optional.of((Definitions)parent);
        }
        return Optional.empty();
    }

    public String getModelNamespace() {
        return this.getParentDefinitions().map(Definitions::getNamespace).orElse(null);
    }

    public String getModelName() {
        return this.getParentDefinitions().map(NamedElement::getName).orElse(null);
    }

    public String getIdentifierString() {
        String identifier = "[unnamed]";
        if (this.source != null) {
            identifier = this.source.getName() != null ? this.source.getName() : this.source.getId();
        }
        return identifier;
    }

    public NamedElement getSource() {
        return this.source;
    }

    public Map<String, DMNNode> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Map<String, DMNNode> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(String name, DMNNode dependency) {
        this.dependencies.put(name, dependency);
    }

    public List<InformationRequirement> getInformationRequirement() {
        if (this.source instanceof Decision) {
            return ((Decision)this.source).getInformationRequirement();
        }
        return Collections.emptyList();
    }

    public List<KnowledgeRequirement> getKnowledgeRequirement() {
        if (this.source instanceof Decision) {
            return ((Decision)this.source).getKnowledgeRequirement();
        }
        if (this.source instanceof BusinessKnowledgeModel) {
            return ((BusinessKnowledgeModel)this.source).getKnowledgeRequirement();
        }
        return Collections.emptyList();
    }

    public void addModelImportAliases(Map<String, QName> importAliases) {
        this.importAliases.putAll(importAliases);
    }

    public Optional<String> getModelImportAliasFor(String ns, String iModelName) {
        QName lookup = new QName(ns, iModelName);
        return this.importAliases.entrySet().stream().filter(kv -> ((QName)kv.getValue()).equals(lookup)).map(kv -> (String)kv.getKey()).findFirst();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DMNBaseNode [getName()=");
        builder.append(this.getName());
        builder.append(", getModelNamespace()=");
        builder.append(this.getModelNamespace());
        builder.append("]");
        return builder.toString();
    }
}

