/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.factPattern;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPOperatorsDropdown;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ConstraintValueEditor;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.HasParameterizedOperator;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

public class Connectives {
    private final RuleModeller modeller;
    private final EventBus eventBus;
    private final FactPattern pattern;
    private final Boolean isReadOnly;

    public Connectives(RuleModeller modeller, EventBus eventBus, FactPattern pattern, Boolean isReadOnly) {
        this.pattern = pattern;
        this.modeller = modeller;
        this.eventBus = eventBus;
        this.isReadOnly = isReadOnly;
    }

    public FactPattern getPattern() {
        return this.pattern;
    }

    public SuggestionCompletionEngine getCompletions() {
        return this.modeller.getSuggestionCompletions();
    }

    public Widget connectives(SingleFieldConstraint c, String factClass) {
        HorizontalPanel hp = new HorizontalPanel();
        if (c.connectives != null && c.connectives.length > 0) {
            hp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            hp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
            for (int i = 0; i < c.connectives.length; ++i) {
                ConnectiveConstraint con = c.connectives[i];
                hp.add(this.connectiveOperatorDropDown(con));
                hp.add(this.connectiveValueEditor((BaseSingleFieldConstraint)con));
                if (this.isReadOnly.booleanValue()) continue;
                Image clear = DroolsGuvnorImages.INSTANCE.DeleteItemSmall();
                clear.setAltText(Constants.INSTANCE.RemoveThisRestriction());
                clear.setTitle(Constants.INSTANCE.RemoveThisRestriction());
                clear.addClickHandler(this.createClickHandlerForClearImageButton(c, i));
                hp.add((Widget)clear);
            }
        }
        return hp;
    }

    private Widget connectiveValueEditor(BaseSingleFieldConstraint con) {
        return new ConstraintValueEditor(con, this.pattern.constraintList, this.modeller, this.eventBus, this.isReadOnly.booleanValue());
    }

    private Widget connectiveOperatorDropDown(ConnectiveConstraint cc) {
        if (!this.isReadOnly.booleanValue()) {
            String factType = cc.getFactType();
            String fieldName = cc.getFieldName();
            String[] operators = this.getCompletions().getConnectiveOperatorCompletions(factType, fieldName);
            CEPOperatorsDropdown w = new CEPOperatorsDropdown(operators, (HasParameterizedOperator)cc);
            w.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            return w;
        }
        SmallLabel sl = new SmallLabel("<b>" + (cc.getOperator() == null ? Constants.INSTANCE.pleaseChoose() : HumanReadable.getOperatorDisplayName((String)cc.getOperator())) + "</b>");
        return sl;
    }

    private ClickHandler createClickHandlerForClearImageButton(SingleFieldConstraint sfc, int index) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ RuleModeller access$000(Connectives x0) {
        return x0.modeller;
    }
}

