/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.util.Preconditions;
import org.drools.guvnor.shared.api.PortableObject;

public class ServiceKAgentConfig
implements PortableObject {
    private static final long serialVersionUID = 3792549986118964155L;
    private String name;
    private Boolean newInstance;
    private Boolean useKBaseClassloader;
    private Set<AssetReference> resources;

    public ServiceKAgentConfig() {
    }

    public ServiceKAgentConfig(String name, Boolean newInstance, Boolean useKBaseClassloader, Collection<AssetReference> resources) {
        this.setupNewInstance(name, newInstance, useKBaseClassloader, resources);
    }

    public ServiceKAgentConfig(ServiceKAgentConfig kagent) {
        Preconditions.checkNotNull((String)"kagent", (Object)kagent);
        this.setupNewInstance(kagent.name, kagent.newInstance, kagent.useKBaseClassloader, (Collection)kagent.resources);
    }

    public ServiceKAgentConfig(String name) {
        Preconditions.checkNotEmpty((String)"name", (String)name);
        this.setupNewInstance(name, null, null, null);
    }

    private void setupNewInstance(String name, Boolean newInstance, Boolean useKBaseClassloader, Collection<AssetReference> resources) {
        this.name = Preconditions.checkNotEmpty((String)"name", (String)name);
        this.newInstance = newInstance;
        this.useKBaseClassloader = useKBaseClassloader;
        if (resources != null && resources.size() > 0) {
            this.resources = new HashSet(resources.size());
            for (AssetReference resource : resources) {
                this.resources.add(new AssetReference(resource));
            }
        } else {
            this.resources = new HashSet();
        }
    }

    public String getName() {
        return this.name;
    }

    public Boolean getNewInstance() {
        return this.newInstance;
    }

    public Boolean getUseKBaseClassloader() {
        return this.useKBaseClassloader;
    }

    public Collection<AssetReference> getResources() {
        return this.resources;
    }

    public void setNewInstance(boolean newInstance) {
        this.newInstance = newInstance;
    }

    public void setUseKBaseClassloader(boolean useKBaseClassloader) {
        this.useKBaseClassloader = useKBaseClassloader;
    }

    public void addResources(Collection<AssetReference> resources) {
        if (resources == null || resources.size() == 0) {
            return;
        }
        for (AssetReference resource : resources) {
            this.resources.add(new AssetReference(resource));
        }
    }

    public void addResource(AssetReference resource) {
        Preconditions.checkNotNull((String)"resource", (Object)resource);
        this.resources.add(new AssetReference(resource));
    }

    public void removeResource(AssetReference resource) {
        if (resource == null) {
            return;
        }
        this.resources.remove(resource);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceKAgentConfig that = (ServiceKAgentConfig)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.newInstance != null ? !this.newInstance.equals(that.newInstance) : that.newInstance != null) {
            return false;
        }
        if (this.useKBaseClassloader != null ? !this.useKBaseClassloader.equals(that.useKBaseClassloader) : that.useKBaseClassloader != null) {
            return false;
        }
        return !(this.resources != null ? !((Object)this.resources).equals(that.resources) : that.resources != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.newInstance != null ? this.newInstance.hashCode() : 0);
        result = 31 * result + (this.useKBaseClassloader != null ? this.useKBaseClassloader.hashCode() : 0);
        result = 31 * result + (this.resources != null ? ((Object)this.resources).hashCode() : 0);
        return result;
    }
}

