/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.drools.guvnor.client.decisiontable.widget.DTCellValueUtilities;
import org.drools.guvnor.client.util.DateConverter;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class DTCellValueUtilities {
    protected static DateConverter DATE_CONVERTOR = null;
    private final GuidedDecisionTable52 model;
    private final SuggestionCompletionEngine sce;

    public static void injectDateConvertor(DateConverter dc) {
        DATE_CONVERTOR = dc;
    }

    public DTCellValueUtilities(GuidedDecisionTable52 model, SuggestionCompletionEngine sce) {
        this.model = model;
        this.sce = sce;
    }

    public DTDataTypes52 getDataType(BaseColumn column) {
        ConditionCol52 cc;
        if (column instanceof LimitedEntryCol) {
            return DTDataTypes52.BOOLEAN;
        }
        if (column instanceof ActionWorkItemCol52) {
            return DTDataTypes52.BOOLEAN;
        }
        if (column instanceof ActionWorkItemSetFieldCol52 || column instanceof ActionWorkItemInsertFactCol52) {
            return DTDataTypes52.BOOLEAN;
        }
        if (column instanceof ConditionCol52 && (cc = (ConditionCol52)column).getOperator() != null && (cc.getOperator().equals("== null") || cc.getOperator().equals("!= null"))) {
            return DTDataTypes52.BOOLEAN;
        }
        return this.model.getTypeSafeType(column, this.sce);
    }

    public DTDataTypes52 getDataType(Pattern52 pattern, ConditionCol52 condition) {
        if (condition instanceof LimitedEntryCol) {
            return DTDataTypes52.BOOLEAN;
        }
        if (condition.getOperator() != null && (condition.getOperator().equals("== null") || condition.getOperator().equals("!= null"))) {
            return DTDataTypes52.BOOLEAN;
        }
        return this.model.getTypeSafeType(pattern, condition, this.sce);
    }

    public DTDataTypes52 getDataType(Pattern52 pattern, ActionSetFieldCol52 action) {
        if (action instanceof LimitedEntryCol) {
            return DTDataTypes52.BOOLEAN;
        }
        return this.model.getTypeSafeType(pattern, action, this.sce);
    }

    public void assertDTCellValue(DTDataTypes52 dataType, DTCellValue52 dcv) {
        if (dcv == null) {
            return;
        }
        if (dataType.equals((Object)dcv.getDataType())) {
            return;
        }
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dcv.getDataType().ordinal()]) {
            case 1: {
                this.convertDTCellValueFromNumeric(dataType, dcv);
                break;
            }
            default: {
                this.convertDTCellValueFromString(dataType, dcv);
            }
        }
    }

    public String asString(DTCellValue52 dcv) {
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dcv.getDataType().ordinal()]) {
            case 2: {
                return this.convertBooleanValueToString(dcv);
            }
            case 3: {
                return this.convertDateValueToString(dcv);
            }
            case 1: {
                return this.convertNumericValueToString(dcv);
            }
            case 4: {
                return this.convertBigDecimalValueToString(dcv);
            }
            case 5: {
                return this.convertBigIntegerValueToString(dcv);
            }
            case 6: {
                return this.convertByteValueToString(dcv);
            }
            case 7: {
                return this.convertDoubleValueToString(dcv);
            }
            case 8: {
                return this.convertFloatValueToString(dcv);
            }
            case 9: {
                return this.convertIntegerValueToString(dcv);
            }
            case 10: {
                return this.convertLongValueToString(dcv);
            }
            case 11: {
                return this.convertShortValueToString(dcv);
            }
        }
        return this.convertStringValueToString(dcv);
    }

    private String convertBooleanValueToString(DTCellValue52 dcv) {
        Boolean value = dcv.getBooleanValue();
        return value == null ? "" : value.toString();
    }

    private String convertDateValueToString(DTCellValue52 dcv) {
        Date value = dcv.getDateValue();
        String result = "";
        if (value != null) {
            result = DATE_CONVERTOR.format(value);
        }
        return result;
    }

    private String convertNumericValueToString(DTCellValue52 dcv) {
        BigDecimal value = (BigDecimal)dcv.getNumericValue();
        return value == null ? "" : value.toPlainString();
    }

    private String convertBigDecimalValueToString(DTCellValue52 dcv) {
        BigDecimal value = (BigDecimal)dcv.getNumericValue();
        return value == null ? "" : value.toPlainString();
    }

    private String convertBigIntegerValueToString(DTCellValue52 dcv) {
        BigInteger value = (BigInteger)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertByteValueToString(DTCellValue52 dcv) {
        Byte value = (Byte)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertDoubleValueToString(DTCellValue52 dcv) {
        Double value = (Double)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertFloatValueToString(DTCellValue52 dcv) {
        Float value = (Float)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertIntegerValueToString(DTCellValue52 dcv) {
        Integer value = (Integer)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertLongValueToString(DTCellValue52 dcv) {
        Long value = (Long)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertShortValueToString(DTCellValue52 dcv) {
        Short value = (Short)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertStringValueToString(DTCellValue52 dcv) {
        String value = dcv.getStringValue();
        return value == null ? "" : value;
    }

    private void convertDTCellValueFromString(DTDataTypes52 dataType, DTCellValue52 dcv) {
        String text = dcv.getStringValue();
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dataType.ordinal()]) {
            case 2: {
                dcv.setBooleanValue(Boolean.valueOf(text == null ? false : Boolean.valueOf(text)));
                break;
            }
            case 3: {
                Date d = null;
                try {
                    if (text != null) {
                        if (DATE_CONVERTOR == null) {
                            throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
                        }
                        d = DATE_CONVERTOR.parse(text);
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                dcv.setDateValue(d);
                break;
            }
            case 1: {
                BigDecimal numericValue = null;
                try {
                    if (text != null) {
                        numericValue = new BigDecimal(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(numericValue);
                break;
            }
            case 4: {
                BigDecimal bigDecimalValue = null;
                try {
                    if (text != null) {
                        bigDecimalValue = new BigDecimal(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(bigDecimalValue);
                break;
            }
            case 5: {
                BigInteger bigIntegerValue = null;
                try {
                    if (text != null) {
                        bigIntegerValue = new BigInteger(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(bigIntegerValue);
                break;
            }
            case 6: {
                Byte byteValue = null;
                try {
                    if (text != null) {
                        byteValue = new Byte(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(byteValue);
                break;
            }
            case 7: {
                Double doubleValue = null;
                try {
                    if (text != null) {
                        doubleValue = new Double(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(doubleValue);
                break;
            }
            case 8: {
                Float floatValue = null;
                try {
                    if (text != null) {
                        floatValue = new Float(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(floatValue);
                break;
            }
            case 9: {
                Integer integerValue = null;
                try {
                    if (text != null) {
                        integerValue = new Integer(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(integerValue);
                break;
            }
            case 10: {
                Long longValue = null;
                try {
                    if (text != null) {
                        longValue = new Long(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(longValue);
                break;
            }
            case 11: {
                Short shortValue = null;
                try {
                    if (text != null) {
                        shortValue = new Short(text);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                dcv.setNumericValue(shortValue);
            }
        }
    }

    private void convertDTCellValueFromNumeric(DTDataTypes52 dataType, DTCellValue52 dcv) {
        BigDecimal value = (BigDecimal)dcv.getNumericValue();
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dataType.ordinal()]) {
            case 4: {
                dcv.setNumericValue(value == null ? null : value);
                break;
            }
            case 5: {
                dcv.setNumericValue(value == null ? null : value.toBigInteger());
                break;
            }
            case 6: {
                dcv.setNumericValue(value == null ? null : Byte.valueOf(value.byteValue()));
                break;
            }
            case 7: {
                dcv.setNumericValue(value == null ? null : Double.valueOf(value.doubleValue()));
                break;
            }
            case 8: {
                dcv.setNumericValue(value == null ? null : Float.valueOf(value.floatValue()));
                break;
            }
            case 9: {
                dcv.setNumericValue(value == null ? null : Integer.valueOf(value.intValue()));
                break;
            }
            case 10: {
                dcv.setNumericValue(value == null ? null : Long.valueOf(value.longValue()));
                break;
            }
            case 11: {
                dcv.setNumericValue(value == null ? null : Short.valueOf(value.shortValue()));
            }
        }
    }
}

