/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.event.shared.EventBus;
import org.drools.guvnor.client.decisiontable.cells.AnalysisCell;
import org.drools.guvnor.client.decisiontable.cells.PopupBoundPatternDropDownEditCell;
import org.drools.guvnor.client.decisiontable.cells.PopupDialectDropDownEditCell;
import org.drools.guvnor.client.decisiontable.cells.PopupDropDownEditCell;
import org.drools.guvnor.client.decisiontable.cells.PopupTextEditCell;
import org.drools.guvnor.client.decisiontable.cells.PopupValueListDropDownEditCell;
import org.drools.guvnor.client.decisiontable.cells.RowNumberCell;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableDropDownManager;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractCellFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellTableDropDownDataValueMapProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.DecoratedGridCellValueAdaptor;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionRetractFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.Analysis;
import org.drools.ide.common.client.modeldriven.dt52.AnalysisCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLRuleModel;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.RowNumberCol52;

public class DecisionTableCellFactory
extends AbstractCellFactory<BaseColumn> {
    private GuidedDecisionTable52 model;

    public DecisionTableCellFactory(GuidedDecisionTable52 model, SuggestionCompletionEngine sce, DecisionTableDropDownManager dropDownManager, boolean isReadOnly, EventBus eventBus) {
        super(sce, (CellTableDropDownDataValueMapProvider)dropDownManager, isReadOnly, eventBus);
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
    }

    public DecoratedGridCellValueAdaptor<? extends Comparable<?>> getCell(BaseColumn column) {
        DecoratedGridCellValueAdaptor cell = this.makeTextCell();
        if (column instanceof RowNumberCol52) {
            cell = this.makeRowNumberCell();
        } else if (column instanceof AttributeCol52) {
            AttributeCol52 attrCol = (AttributeCol52)column;
            String attrName = attrCol.getAttribute();
            if (attrName.equals("salience")) {
                cell = attrCol.isUseRowNumber() ? this.makeRowNumberCell() : this.makeNumericIntegerCell();
            } else if (attrName.equals("enabled")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("no-loop")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("duration")) {
                cell = this.makeNumericLongCell();
            } else if (attrName.equals("timer")) {
                cell = this.makeTimerCell();
            } else if (attrName.equals("calendars")) {
                cell = this.makeCalendarsCell();
            } else if (attrName.equals("auto-focus")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("lock-on-active")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("date-effective")) {
                cell = this.makeDateCell();
            } else if (attrName.equals("date-expires")) {
                cell = this.makeDateCell();
            } else if (attrName.equals("dialect")) {
                cell = this.makeDialectCell();
            } else if (attrName.equals("negate")) {
                cell = this.makeBooleanCell();
            }
        } else if (column instanceof LimitedEntryCol) {
            cell = this.makeBooleanCell();
        } else if (column instanceof BRLConditionVariableColumn) {
            cell = this.derieveCellFromCondition((BRLConditionVariableColumn)column);
        } else if (column instanceof ConditionCol52) {
            cell = this.derieveCellFromCondition((ConditionCol52)column);
        } else if (column instanceof ActionWorkItemSetFieldCol52) {
            cell = this.makeBooleanCell();
        } else if (column instanceof ActionWorkItemInsertFactCol52) {
            cell = this.makeBooleanCell();
        } else if (column instanceof ActionSetFieldCol52) {
            cell = this.derieveCellFromAction((ActionSetFieldCol52)column);
        } else if (column instanceof ActionInsertFactCol52) {
            cell = this.derieveCellFromAction((ActionInsertFactCol52)column);
        } else if (column instanceof ActionRetractFactCol52) {
            cell = this.derieveCellFromAction((ActionRetractFactCol52)column);
        } else if (column instanceof ActionWorkItemCol52) {
            cell = this.makeBooleanCell();
        } else if (column instanceof BRLActionVariableColumn) {
            cell = this.derieveCellFromAction((BRLActionVariableColumn)column);
        } else if (column instanceof AnalysisCol52) {
            cell = this.makeRowAnalysisCell();
        }
        return cell;
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromCondition(ConditionCol52 col) {
        if (col.getOperator() != null && (col.getOperator().equals("== null") || col.getOperator().equals("!= null"))) {
            return this.makeBooleanCell();
        }
        String factType = this.model.getPattern(col).getFactType();
        String fieldName = col.getFactField();
        if (this.model.hasValueList(col)) {
            return this.makeValueListCell((DTColumnConfig52)col);
        }
        if (this.sce.hasEnums(factType, fieldName)) {
            return this.makeEnumCell(factType, fieldName);
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromCondition(BRLConditionVariableColumn col) {
        String fieldName;
        String factType = col.getFactType();
        if (this.sce.hasEnums(factType, fieldName = col.getFactField())) {
            return this.makeEnumCell(factType, fieldName);
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromAction(ActionSetFieldCol52 col) {
        String factType = this.model.getBoundFactType(col.getBoundName());
        String fieldName = col.getFactField();
        if (this.model.hasValueList(col)) {
            return this.makeValueListCell((DTColumnConfig52)col);
        }
        if (this.sce.hasEnums(factType, fieldName)) {
            return this.makeEnumCell(factType, fieldName);
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromAction(ActionInsertFactCol52 col) {
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        if (this.model.hasValueList(col)) {
            return this.makeValueListCell((DTColumnConfig52)col);
        }
        if (this.sce.hasEnums(factType, fieldName)) {
            return this.makeEnumCell(factType, fieldName);
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromAction(ActionRetractFactCol52 col) {
        PopupBoundPatternDropDownEditCell pudd = new PopupBoundPatternDropDownEditCell(this.eventBus, this.isReadOnly);
        BRLRuleModel rm = new BRLRuleModel(this.model);
        pudd.setFactBindings(rm.getLHSBoundFacts());
        return new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromAction(BRLActionVariableColumn col) {
        String fieldName;
        String factType = col.getFactType();
        if (this.sce.hasEnums(factType, fieldName = col.getFactField())) {
            return this.makeEnumCell(factType, fieldName);
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromModel(DTColumnConfig52 col) {
        DecoratedGridCellValueAdaptor cell = this.makeTextCell();
        String type = this.model.getType((BaseColumn)col, this.sce);
        if (type.equals("Numeric")) {
            cell = this.makeNumericCell();
        } else if (type.equals("BigDecimal")) {
            cell = this.makeNumericBigDecimalCell();
        } else if (type.equals("BigInteger")) {
            cell = this.makeNumericBigIntegerCell();
        } else if (type.equals("Byte")) {
            cell = this.makeNumericByteCell();
        } else if (type.equals("Double")) {
            cell = this.makeNumericDoubleCell();
        } else if (type.equals("Float")) {
            cell = this.makeNumericFloatCell();
        } else if (type.equals("Integer")) {
            cell = this.makeNumericIntegerCell();
        } else if (type.equals("Long")) {
            cell = this.makeNumericLongCell();
        } else if (type.equals("Short")) {
            cell = this.makeNumericShortCell();
        } else if (type.equals("Boolean")) {
            cell = this.makeBooleanCell();
        } else if (type.equals("Date")) {
            cell = this.makeDateCell();
        }
        return cell;
    }

    private DecoratedGridCellValueAdaptor<String> makeDialectCell() {
        PopupDialectDropDownEditCell pudd = new PopupDialectDropDownEditCell(this.isReadOnly);
        return new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<Integer> makeRowNumberCell() {
        return new DecoratedGridCellValueAdaptor((AbstractCell)new RowNumberCell(), this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<String> makeTimerCell() {
        return new DecoratedGridCellValueAdaptor((AbstractCell)new PopupTextEditCell(this.isReadOnly), this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<String> makeCalendarsCell() {
        return new DecoratedGridCellValueAdaptor((AbstractCell)new PopupTextEditCell(this.isReadOnly), this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<Analysis> makeRowAnalysisCell() {
        return new DecoratedGridCellValueAdaptor((AbstractCell)new AnalysisCell(), this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> makeValueListCell(DTColumnConfig52 col) {
        PopupValueListDropDownEditCell pudd = new PopupValueListDropDownEditCell(this.model.getValueList((BaseColumn)col), this.isReadOnly);
        DecoratedGridCellValueAdaptor cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        return cell;
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> makeEnumCell(String factType, String fieldName) {
        PopupDropDownEditCell pudd = new PopupDropDownEditCell(factType, fieldName, this.sce, this.dropDownManager, this.isReadOnly);
        DecoratedGridCellValueAdaptor cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        return cell;
    }
}

