/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget.auditlog;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.HasKeyboardPagingPolicy;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.Popup;
import org.drools.guvnor.client.decisiontable.widget.auditlog.AuditLogEntryCellHelper;
import org.drools.guvnor.client.decisiontable.widget.auditlog.AuditLogEntryCommentColumn;
import org.drools.guvnor.client.decisiontable.widget.auditlog.AuditLogEntryDeleteCommentColumn;
import org.drools.guvnor.client.decisiontable.widget.auditlog.AuditLogEntrySummaryColumn;
import org.drools.guvnor.client.decisiontable.widget.auditlog.AuditLogView;
import org.drools.guvnor.client.decisiontable.widget.auditlog.AuditLogViewImpl;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.UserSecurityContext;
import org.drools.guvnor.client.widgets.tables.GuvnorSimplePager;
import org.drools.ide.common.client.modeldriven.auditlog.AuditLog;
import org.drools.ide.common.client.modeldriven.auditlog.AuditLogEntry;

public class AuditLogViewImpl
extends Popup
implements AuditLogView {
    protected int MIN_WIDTH = 500;
    protected int MIN_HEIGHT = 200;
    private final AuditLog auditLog;
    private final Widget popupContent;
    @UiField
    ScrollPanel spEvents;
    private DisclosurePanel dpEventTypes;
    private CellTable<AuditLogEntry> events;
    private final VerticalPanel lstEventTypes = new VerticalPanel();
    private final UserSecurityContext userSecurityContext;
    private static AuditLogViewImplBinder uiBinder = (AuditLogViewImplBinder)GWT.create(AuditLogViewImplBinder.class);

    public AuditLogViewImpl(AuditLog auditLog, UserSecurityContext userSecurityContext) {
        this.setTitle(Constants.INSTANCE.DecisionTableAuditLog());
        this.auditLog = auditLog;
        this.userSecurityContext = userSecurityContext;
        this.setHeight(this.getPopupHeight() + "px");
        this.setWidth(this.getPopupWidth() + "px");
        this.popupContent = (Widget)uiBinder.createAndBindUi((Object)this);
    }

    private int getPopupWidth() {
        int w = (int)((double)Window.getClientWidth() * 0.5);
        if (w < this.MIN_WIDTH) {
            w = this.MIN_WIDTH;
        }
        return w;
    }

    protected int getPopupHeight() {
        int h = (int)((double)Window.getClientHeight() * 0.5);
        if (h < this.MIN_HEIGHT) {
            h = this.MIN_HEIGHT;
        }
        return h;
    }

    public Widget getContent() {
        for (Map.Entry e : this.auditLog.getAuditLogFilter().getAcceptedTypes().entrySet()) {
            this.lstEventTypes.add(this.makeEventTypeCheckBox((String)e.getKey(), (Boolean)e.getValue()));
        }
        this.events = new CellTable();
        ListDataProvider dlp = new ListDataProvider(this.filterDeletedEntries((List)this.auditLog));
        dlp.addDataDisplay((HasData)this.events);
        AuditLogEntrySummaryColumn summaryColumn = new AuditLogEntrySummaryColumn();
        AuditLogEntryCommentColumn commentColumn = new AuditLogEntryCommentColumn();
        this.events.addColumn((Column)summaryColumn);
        this.events.addColumn((Column)commentColumn);
        this.events.setColumnWidth((Column)summaryColumn, 50.0, Style.Unit.PCT);
        this.events.setColumnWidth((Column)commentColumn, 50.0, Style.Unit.PCT);
        if (!this.userSecurityContext.isAdministrator()) {
            AuditLogEntryDeleteCommentColumn deleteCommentColumn = new AuditLogEntryDeleteCommentColumn();
            deleteCommentColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
            this.events.addColumn((Column)deleteCommentColumn);
            this.events.setColumnWidth((Column)commentColumn, 45.0, Style.Unit.PCT);
            this.events.setColumnWidth((Column)deleteCommentColumn, 5.0, Style.Unit.PCT);
        }
        this.events.setEmptyTableWidget((Widget)new Label(Constants.INSTANCE.DecisionTableAuditLogNoEntries()));
        this.events.setKeyboardPagingPolicy(HasKeyboardPagingPolicy.KeyboardPagingPolicy.CHANGE_PAGE);
        this.events.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED);
        this.events.setPageSize(5);
        GuvnorSimplePager gsp = new GuvnorSimplePager();
        gsp.setPageSize(5);
        gsp.setDisplay((HasRows)this.events);
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)gsp);
        vp.add((Widget)this.events);
        this.spEvents.setAlwaysShowScrollBars(false);
        this.spEvents.add((Widget)vp);
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        return this.popupContent;
    }

    private Widget makeEventTypeCheckBox(String eventType, Boolean isEnabled) {
        CheckBox chkEventType = new CheckBox(AuditLogEntryCellHelper.getEventTypeDisplayText((String)eventType));
        chkEventType.setValue(Boolean.valueOf(Boolean.TRUE.equals(isEnabled)));
        chkEventType.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return chkEventType;
    }

    private void fixWidgetSizes() {
        int lstEventsHeight = this.getClientHeight() - this.dpEventTypes.getOffsetHeight();
        this.events.setWidth(this.spEvents.getElement().getClientWidth() + "px");
        this.spEvents.setHeight(lstEventsHeight + "px");
    }

    @UiFactory
    DisclosurePanel makeEventTypeDisclosurePanel() {
        this.dpEventTypes = new DisclosurePanel(Constants.INSTANCE.DecisionTableAuditLogEvents());
        this.dpEventTypes.add((Widget)this.lstEventTypes);
        this.dpEventTypes.addOpenHandler((OpenHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.dpEventTypes.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
        return this.dpEventTypes;
    }

    private List<AuditLogEntry> filterDeletedEntries(List<AuditLogEntry> entries) {
        if (this.userSecurityContext.isAdministrator()) {
            return entries;
        }
        ArrayList<AuditLogEntry> filteredEntries = new ArrayList<AuditLogEntry>();
        for (AuditLogEntry entry : entries) {
            if (entry.isDeleted()) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    static /* synthetic */ AuditLog access$000(AuditLogViewImpl x0) {
        return x0.auditLog;
    }

    static /* synthetic */ List access$100(AuditLogViewImpl x0, List x1) {
        return x0.filterDeletedEntries(x1);
    }

    static /* synthetic */ void access$200(AuditLogViewImpl x0) {
        x0.fixWidgetSizes();
    }
}

