/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.logical.shared.HasResizeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractDecoratedGridHeaderWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.ResourcesProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.SortConfiguration;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.DeleteColumnEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.InsertInternalColumnEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.MoveColumnsEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SetColumnVisibilityEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SetInternalModelEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateColumnDefinitionEvent;
import org.drools.guvnor.client.widgets.tables.SortDirection;

public abstract class AbstractDecoratedGridHeaderWidget<M, T>
extends CellPanel
implements HasResizeHandlers,
SetInternalModelEvent.Handler<M, T>,
DeleteColumnEvent.Handler,
InsertInternalColumnEvent.Handler<T>,
SetColumnVisibilityEvent.Handler,
UpdateColumnDefinitionEvent.Handler,
MoveColumnsEvent.Handler {
    private static final int MIN_COLUMN_WIDTH = 16;
    protected Panel panel;
    protected M model;
    protected List<DynamicColumn<T>> sortableColumns = new ArrayList();
    protected final boolean isReadOnly;
    protected ResourcesProvider<T> resources;
    protected EventBus eventBus;
    private ResizerInformation resizerInfo = new ResizerInformation(this);
    private DivElement resizer;
    private UIObject parent;

    public AbstractDecoratedGridHeaderWidget(ResourcesProvider<T> resources, boolean isReadOnly, EventBus eventBus) {
        if (resources == null) {
            throw new IllegalArgumentException("resources cannot be null");
        }
        if (eventBus == null) {
            throw new IllegalArgumentException("eventBus cannot be null");
        }
        this.resources = resources;
        this.isReadOnly = isReadOnly;
        this.eventBus = eventBus;
        Element tre = DOM.createTR();
        Element tce = DOM.createTD();
        Element div = DOM.createDiv();
        div.getStyle().setPosition(Style.Position.RELATIVE);
        ((TableElement)this.getBody().getParentElement().cast()).setCellSpacing(0);
        ((TableElement)this.getBody().getParentElement().cast()).setCellPadding(0);
        tce.appendChild((Node)div);
        tre.appendChild((Node)tce);
        this.getBody().appendChild((Node)tre);
        this.panel = new ScrollPanel();
        this.panel.getElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.panel.add(this.getHeaderWidget());
        this.add((Widget)this.panel, div);
        this.resizer = (DivElement)DOM.createDiv().cast();
        this.resizer.addClassName(resources.headerResizer());
        this.resizer.getStyle().setTop(0.0, Style.Unit.PX);
        div.appendChild((Node)this.resizer);
        this.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, MouseMoveEvent.getType());
        this.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, MouseDownEvent.getType());
        this.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, MouseUpEvent.getType());
        this.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, MouseOutEvent.getType());
        eventBus.addHandler(DeleteColumnEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(SetColumnVisibilityEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(UpdateColumnDefinitionEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(MoveColumnsEvent.TYPE, (EventHandler)this);
    }

    public HandlerRegistration addResizeHandler(ResizeHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        return this.addHandler((EventHandler)handler, ResizeEvent.getType());
    }

    public abstract void redraw();

    public abstract void setScrollPosition(int var1);

    public void setWidth(String width) {
        super.setWidth(width);
        this.panel.setWidth(width);
    }

    private void setResizerDimensions(int position) {
        this.resizer.getStyle().setHeight((double)this.parent.getElement().getClientHeight(), Style.Unit.PX);
        this.resizer.getStyle().setLeft((double)position, Style.Unit.PX);
    }

    void setSidebar(UIObject parent) {
        this.parent = parent;
    }

    protected abstract Widget getHeaderWidget();

    protected abstract ResizerInformation getResizerInformation(int var1);

    protected abstract void resizeColumn(DynamicColumn<T> var1, int var2);

    protected void updateSortOrder(DynamicColumn<T> column) {
        TreeMap<Integer, DynamicColumn> sortedColumns = new TreeMap<Integer, DynamicColumn>();
        switch (column.getSortIndex()) {
            case -1: {
                for (DynamicColumn sortedColumn : this.sortableColumns) {
                    if (sortedColumn.getSortDirection() == SortDirection.NONE) continue;
                    sortedColumns.put(sortedColumn.getSortIndex(), sortedColumn);
                }
                int sortIndex = 1;
                for (DynamicColumn sortedColumn : sortedColumns.values()) {
                    sortedColumn.setSortIndex(sortIndex);
                    ++sortIndex;
                }
                column.setSortIndex(0);
                column.setSortDirection(SortDirection.ASCENDING);
                break;
            }
            case 0: {
                if (column.getSortDirection() == SortDirection.ASCENDING) {
                    column.setSortDirection(SortDirection.DESCENDING);
                    break;
                }
                if (column.getSortDirection() != SortDirection.DESCENDING) break;
                column.setSortDirection(SortDirection.NONE);
                column.clearSortIndex();
                for (DynamicColumn sortedColumn : this.sortableColumns) {
                    if (sortedColumn.getSortDirection() == SortDirection.NONE) continue;
                    sortedColumns.put(sortedColumn.getSortIndex(), sortedColumn);
                }
                int sortIndex = 0;
                for (DynamicColumn sortedColumn : sortedColumns.values()) {
                    sortedColumn.setSortIndex(sortIndex);
                    ++sortIndex;
                }
                break;
            }
            default: {
                for (DynamicColumn sortedColumn : this.sortableColumns) {
                    if (sortedColumn.getSortDirection() == SortDirection.NONE || sortedColumn.equals(column)) continue;
                    sortedColumns.put(sortedColumn.getSortIndex() + 1, sortedColumn);
                }
                column.setSortIndex(0);
                int sortIndex = 1;
                for (DynamicColumn sortedColumn : sortedColumns.values()) {
                    sortedColumn.setSortIndex(sortIndex);
                    ++sortIndex;
                }
            }
        }
    }

    protected List<SortConfiguration> getSortConfiguration() {
        ArrayList<SortConfiguration> sortConfiguration = new ArrayList<SortConfiguration>();
        List columns = this.sortableColumns;
        for (DynamicColumn column : columns) {
            SortConfiguration sc = column.getSortConfiguration();
            if (sc.getSortIndex() == -1) continue;
            sortConfiguration.add(sc);
        }
        return sortConfiguration;
    }

    public void onDeleteColumn(DeleteColumnEvent event) {
        for (int iCol = 0; iCol < event.getNumberOfColumns(); ++iCol) {
            this.sortableColumns.remove(event.getFirstColumnIndex());
        }
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onInsertInternalColumn(InsertInternalColumnEvent<T> event) {
        int iCol = event.getIndex();
        for (DynamicColumn column : event.getColumns()) {
            this.sortableColumns.add(iCol++, column);
        }
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onSetColumnVisibility(SetColumnVisibilityEvent event) {
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onUpdateColumnDefinition(UpdateColumnDefinitionEvent event) {
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onMoveColumns(MoveColumnsEvent event) {
        int sourceColumnIndex = event.getSourceColumnIndex();
        int targetColumnIndex = event.getTargetColumnIndex();
        int numberOfColumns = event.getNumberOfColumns();
        if (targetColumnIndex > sourceColumnIndex) {
            for (int iCol = 0; iCol < numberOfColumns; ++iCol) {
                this.sortableColumns.add(targetColumnIndex, this.sortableColumns.remove(sourceColumnIndex));
            }
        } else if (targetColumnIndex < sourceColumnIndex) {
            for (int iCol = 0; iCol < numberOfColumns; ++iCol) {
                this.sortableColumns.add(targetColumnIndex, this.sortableColumns.remove(sourceColumnIndex));
                ++sourceColumnIndex;
                ++targetColumnIndex;
            }
        }
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ ResizerInformation access$000(AbstractDecoratedGridHeaderWidget x0) {
        return x0.resizerInfo;
    }

    static /* synthetic */ void access$300(AbstractDecoratedGridHeaderWidget x0, int x1) {
        x0.setResizerDimensions(x1);
    }

    static /* synthetic */ ResizerInformation access$002(AbstractDecoratedGridHeaderWidget x0, ResizerInformation x1) {
        x0.resizerInfo = x1;
        return x0.resizerInfo;
    }

    static /* synthetic */ DivElement access$700(AbstractDecoratedGridHeaderWidget x0) {
        return x0.resizer;
    }
}

