/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ClassLoaderBuilder;
import org.drools.guvnor.server.builder.DSLLoader;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;

public class BRMSSuggestionCompletionLoader
extends SuggestionCompletionLoader {
    public BRMSSuggestionCompletionLoader() {
    }

    public BRMSSuggestionCompletionLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public SuggestionCompletionEngine getSuggestionEngine(ModuleItem packageItem, String droolsHeader) {
        StringBuilder buf = new StringBuilder();
        AssetItemIterator it = packageItem.listAssetsByFormat(new String[]{"model.drl"});
        while (it.hasNext()) {
            AssetItem as = it.next();
            buf.append(as.getContent());
            buf.append('\n');
        }
        ClassLoaderBuilder classLoaderBuilder = new ClassLoaderBuilder(packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"jar"}));
        return super.getSuggestionEngine(droolsHeader + "\n" + buf.toString(), classLoaderBuilder.getJarInputStreams(), this.getDSLMappingFiles(packageItem), this.getDataEnums(packageItem));
    }

    public SuggestionCompletionEngine getSuggestionEngine(ModuleItem pkg) {
        return this.getSuggestionEngine(pkg, DroolsHeader.getDroolsHeader((ModuleItem)pkg));
    }

    private List<String> getDataEnums(ModuleItem pkg) {
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"enumeration"});
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            AssetItem item = (AssetItem)it.next();
            list.add(item.getContent());
        }
        return list;
    }

    private List<DSLTokenizedMappingFile> getDSLMappingFiles(ModuleItem pkg) {
        return DSLLoader.loadDSLMappingFiles((ModuleItem)pkg, (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */);
    }
}

