/*
 * Decompiled with CFR 0.152.
 */
package jmaki.xhp;

import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmaki.xhp.XmlHttpProxy;
import org.json.JSONObject;

public class XmlHttpProxyServlet
extends HttpServlet {
    public static String REMOTE_USER = "REMOTE_USER";
    private static String XHP_LAST_MODIFIED = "xhp_last_modified_key";
    private static String XHP_CONFIG = "xhp.json";
    private static boolean allowXDomain = false;
    private static boolean requireSession = false;
    private static boolean createSession = false;
    private static String defaultContentType = "application/json;charset=UTF-8";
    private static boolean rDebug = false;
    private Logger logger = null;
    private XmlHttpProxy xhp = null;
    private ServletContext ctx;
    private JSONObject services = null;
    private String resourcesDir = "/resources/";
    private String classpathResourcesDir = "/META-INF/resources/";
    private String headerToken = "jmaki-";
    private String testToken = "xtest-";
    private static String testUser;
    private static String testPass;
    private static String setCookie;

    public XmlHttpProxyServlet() {
        if (rDebug) {
            this.logger = this.getLogger();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        String createSessionString;
        String xdomainString;
        String requireSessionString;
        super.init(config);
        this.ctx = config.getServletContext();
        if (this.ctx.getInitParameter("responseContentType") != null) {
            defaultContentType = this.ctx.getInitParameter("responseContentType");
        }
        if (this.ctx.getInitParameter("jmaki-xhp-resources") != null) {
            this.resourcesDir = this.ctx.getInitParameter("jmaki-xhp-resources");
        } else if (this.ctx.getInitParameter("jmaki-resources") != null) {
            this.resourcesDir = this.ctx.getInitParameter("jmaki-resources");
        }
        if (this.ctx.getInitParameter("jmaki-classpath-resources") != null) {
            this.classpathResourcesDir = this.ctx.getInitParameter("jmaki-classpath-resources");
        }
        if ((requireSessionString = this.ctx.getInitParameter("requireSession")) == null) {
            requireSessionString = this.ctx.getInitParameter("jmaki-requireSession");
        }
        if (requireSessionString != null) {
            if ("false".equals(requireSessionString)) {
                requireSession = false;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. Session requirement disabled.");
            } else if ("true".equals(requireSessionString)) {
                requireSession = true;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. Session requirement enabled.");
            }
        }
        if ((xdomainString = this.ctx.getInitParameter("allowXDomain")) == null) {
            xdomainString = this.ctx.getInitParameter("jmaki-allowXDomain");
        }
        if (xdomainString != null) {
            if ("true".equals(xdomainString)) {
                allowXDomain = true;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. xDomain access is enabled.");
            } else if ("false".equals(xdomainString)) {
                allowXDomain = false;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. xDomain access is disabled.");
            }
        }
        if ((createSessionString = this.ctx.getInitParameter("jmaki-createSession")) != null) {
            if ("true".equals(createSessionString)) {
                createSession = true;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. create session is enabled.");
            } else if ("false".equals(xdomainString)) {
                createSession = false;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. create session is disabled.");
            }
        }
        String proxyHost = this.ctx.getInitParameter("proxyHost");
        String proxyPortString = this.ctx.getInitParameter("proxyPort");
        if (proxyHost != null && proxyPortString != null) {
            int proxyPort = 8080;
            try {
                proxyPort = new Integer(proxyPortString);
                this.xhp = new XmlHttpProxy(proxyHost, proxyPort);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().severe("XmlHttpProxyServlet: intialization error. The proxyPort must be a number");
                throw new ServletException("XmlHttpProxyServlet: intialization error. The proxyPort must be a number");
            }
        } else {
            this.xhp = new XmlHttpProxy();
        }
    }

    private void getServices(HttpServletResponse res) {
        InputStream is = null;
        try {
            URL url = this.ctx.getResource(this.resourcesDir + XHP_CONFIG);
            if (url == null) {
                url = XmlHttpProxyServlet.class.getResource(XHP_CONFIG);
            }
            is = url.openStream();
        }
        catch (Exception ex) {
            try {
                this.getLogger().severe("XmlHttpProxyServlet error loading xhp.json : " + ex);
                PrintWriter writer = res.getWriter();
                writer.write("XmlHttpProxyServlet Error: Error loading xhp.json. Make sure it is available in the /resources directory of your applicaton.");
                writer.flush();
            }
            catch (Exception iox) {
                // empty catch block
            }
        }
        this.services = XmlHttpProxy.loadServices(is);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) {
        this.doProcess(req, res, XmlHttpProxy.DELETE);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.doProcess(req, res, XmlHttpProxy.GET);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) {
        this.doProcess(req, res, XmlHttpProxy.POST);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) {
        this.doProcess(req, res, XmlHttpProxy.PUT);
    }

    /*
     * Exception decompiling
     */
    public void doProcess(HttpServletRequest req, HttpServletResponse res, String method) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String processURL(String url, HttpServletRequest req, HttpServletResponse res) {
        String serviceURL = url;
        int start = url.indexOf("${");
        int end = url.indexOf("}", start);
        if (end != -1) {
            String prop = url.substring(start + 2, end).trim();
            String replace = "";
            if (REMOTE_USER.equals(prop) && req.getRemoteUser() != null) {
                replace = req.getRemoteUser();
            }
            if (prop.toLowerCase().startsWith("session.")) {
                String sessionKey = prop.substring("session.".length(), prop.length());
                if (req.getSession().getAttribute(sessionKey) != null) {
                    replace = req.getSession().getAttribute(sessionKey).toString();
                }
            }
            serviceURL = serviceURL.substring(0, start) + replace + serviceURL.substring(end + 1, serviceURL.length());
        }
        if (serviceURL.indexOf("${") != -1) {
            serviceURL = this.processURL(serviceURL, req, res);
        }
        return serviceURL;
    }

    private boolean configUpdated() {
        try {
            URL url = this.ctx.getResource(this.resourcesDir + XHP_CONFIG);
            if (url == null) {
                return false;
            }
            URLConnection con = url.openConnection();
            long lastModified = con.getLastModified();
            long XHP_LAST_MODIFIEDModified = 0L;
            if (this.ctx.getAttribute(XHP_LAST_MODIFIED) == null) {
                this.ctx.setAttribute(XHP_LAST_MODIFIED, (Object)new Long(lastModified));
                return false;
            }
            XHP_LAST_MODIFIEDModified = (Long)this.ctx.getAttribute(XHP_LAST_MODIFIED);
            if (XHP_LAST_MODIFIEDModified < lastModified) {
                this.ctx.setAttribute(XHP_LAST_MODIFIED, (Object)new Long(lastModified));
                return true;
            }
        }
        catch (Exception ex) {
            this.getLogger().severe("XmlHttpProxyServlet error checking configuration: " + ex);
        }
        return false;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("jmaki.services.xhp.Log");
            System.out.println("WARN: XHP proxy logging is turned off");
            this.logger.setLevel(Level.OFF);
        }
        return this.logger;
    }

    private void logMessage(String message) {
        if (rDebug) {
            this.getLogger().info(message);
        }
    }
}

