/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.ServerPlugins;
import org.jboss.bpm.console.client.model.PluginInfo;
import org.jboss.bpm.console.client.model.ServerStatus;

public class ServerStatusView
extends LayoutPanel
implements ViewInterface,
LazyPanel {
    public static final String ID = ServerStatusView.class.getName();
    private Controller controller;
    private ApplicationContext appContext;
    private boolean initialized;

    public ServerStatusView(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (!this.initialized) {
            this.update(ServerPlugins.getStatus());
            this.initialized = true;
        }
    }

    private void update(ServerStatus status) {
        this.clear();
        Grid g = new Grid(status.getPlugins().size(), 2);
        g.setWidth("100%");
        for (int row = 0; row < status.getPlugins().size(); ++row) {
            PluginInfo p = (PluginInfo)status.getPlugins().get(row);
            g.setText(row, 0, p.getType());
            Image img = p.isAvailable() ? new Image("images/icons/confirm_small.png") : new Image("images/icons/deny_small.png");
            g.setWidget(row, 1, (Widget)img);
        }
        this.add((Widget)g);
        this.invalidate();
    }
}

