/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.WindowCloseListener;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.Date;
import java.util.List;
import org.gwt.mosaic.ui.client.Caption;
import org.gwt.mosaic.ui.client.Label;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.ToolButton;
import org.gwt.mosaic.ui.client.WindowPanel;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.common.AbstractView;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.process.InstanceDetailView;
import org.jboss.bpm.console.client.process.UpdateInstanceDetailAction;
import org.jboss.bpm.console.client.process.events.InstanceEvent;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.bpm.console.client.util.WindowUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstanceListView
extends AbstractView {
    public static final String ID = InstanceListView.class.getName();
    private Controller controller;
    private LayoutPanel instanceList = null;
    private ListBox<ProcessInstanceRef> listBox;
    private ProcessDefinitionRef currentDefinition;
    private boolean isInitialized;
    private List<ProcessInstanceRef> cachedInstances = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private ApplicationContext appContext;
    private WindowPanel windowPanel = null;
    private Frame frame = null;

    public InstanceListView(ApplicationContext appContext) {
        this.appContext = appContext;
        ConsoleIconBundle icons = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
        this.setTitle("Process Instances");
        this.setIcon(icons.instanceIcon());
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.instanceList = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.instanceList.setPadding(0);
            this.instanceList.setWidgetSpacing(0);
            this.listBox = new ListBox(new String[]{"Instance ID", "State", "Start Date"});
            this.listBox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
            this.listBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            LayoutPanel toolBox = new LayoutPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(5);
            ToolBar toolBar = new ToolBar();
            toolBar.add((Widget)new ToolButton("Refresh", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBar.addSeparator();
            toolBar.add((Widget)new ToolButton("Start", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBar.addSeparator();
            toolBar.add((Widget)new ToolButton("Terminate", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBar.addSeparator();
            toolBar.add((Widget)new ToolButton("Delete", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.instanceList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.instanceList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            if (this.cachedInstances != null) {
                this.bindData(this.cachedInstances);
            }
            LayoutPanel layout = new LayoutPanel((LayoutManager)new BorderLayout());
            layout.add((Widget)this.instanceList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
            InstanceDetailView detailsView = new InstanceDetailView(this.appContext);
            this.controller.addView(InstanceDetailView.ID, (ViewInterface)detailsView);
            this.controller.addAction(UpdateInstanceDetailAction.ID, (ActionInterface)new UpdateInstanceDetailAction());
            layout.add((Widget)detailsView, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, 10, 200));
            this.add((Widget)layout);
            this.isInitialized = true;
        }
    }

    private void createProcessFormWindow(ProcessDefinitionRef process) {
        this.windowPanel = new WindowPanel("Process Interface");
        this.windowPanel.setAnimationEnabled(true);
        this.windowPanel.setSize("320px", "240px");
        LayoutPanel layout = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        layout.setStyleName("bpm-window-layout");
        layout.setPadding(5);
        Label header = new Label("Process: " + process.getId());
        header.setStyleName("bpm-label-header");
        layout.add((Widget)header, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.windowPanel.addWindowCloseListener((WindowCloseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.frame = new Frame();
        DOM.setStyleAttribute((Element)this.frame.getElement(), (String)"border", (String)"none");
        this.frame.getElement().setId(String.valueOf(new Date().getTime()));
        ConsoleLog.debug((String)this.frame.getElement().toString());
        this.frame.setUrl(process.getFormUrl());
        layout.add((Widget)this.frame, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        this.windowPanel.setWidget((Widget)layout);
        WindowUtil.addMaximizeButton((WindowPanel)this.windowPanel, (Caption.CaptionRegion)Caption.CaptionRegion.RIGHT);
        WindowUtil.addMinimizeButton((WindowPanel)this.windowPanel, (Caption.CaptionRegion)Caption.CaptionRegion.RIGHT);
        this.windowPanel.center();
    }

    public ProcessInstanceRef getSelection() {
        ProcessInstanceRef selection = null;
        if (this.listBox.getSelectedIndex() != -1) {
            selection = (ProcessInstanceRef)this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }

    public ProcessDefinitionRef getCurrentDefinition() {
        return this.currentDefinition;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void update(ProcessDefinitionRef def, List<ProcessInstanceRef> instances) {
        this.currentDefinition = def;
        this.cachedInstances = instances;
        if (this.isInitialized()) {
            this.bindData(instances);
            this.controller.handleEvent(new Event(UpdateInstanceDetailAction.ID, (Object)new InstanceEvent(def, null)));
        }
    }

    private void bindData(List<ProcessInstanceRef> instances) {
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        model.clear();
        for (ProcessInstanceRef inst : instances) {
            model.add((Object)inst);
        }
        this.invalidate();
    }

    static /* synthetic */ SimpleDateFormat access$000(InstanceListView x0) {
        return x0.dateFormat;
    }

    static /* synthetic */ ListBox access$100(InstanceListView x0) {
        return x0.listBox;
    }

    static /* synthetic */ ProcessDefinitionRef access$200(InstanceListView x0) {
        return x0.currentDefinition;
    }

    static /* synthetic */ Controller access$300(InstanceListView x0) {
        return x0.controller;
    }

    static /* synthetic */ void access$400(InstanceListView x0, ProcessDefinitionRef x1) {
        x0.createProcessFormWindow(x1);
    }

    static /* synthetic */ WindowPanel access$502(InstanceListView x0, WindowPanel x1) {
        x0.windowPanel = x1;
        return x0.windowPanel;
    }

    static /* synthetic */ Frame access$602(InstanceListView x0, Frame x1) {
        x0.frame = x1;
        return x0.frame;
    }
}

