/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.kie.remote.TopicsConfig;
import org.kie.remote.impl.ClientUtils;
import org.kie.remote.impl.consumer.KafkaListenerThread;
import org.kie.remote.impl.consumer.Listener;
import org.kie.remote.impl.consumer.ListenerThread;
import org.kie.remote.impl.consumer.LocalListenerThread;
import org.kie.remote.impl.producer.EventProducer;
import org.kie.remote.impl.producer.LocalProducer;
import org.kie.remote.impl.producer.Producer;

public class KafkaRemoteUtil {
    private KafkaRemoteUtil() {
    }

    public static Listener getListener(Properties props, boolean isLocal) {
        return new Listener(props, KafkaRemoteUtil.getListenerThread(TopicsConfig.getDefaultTopicsConfig(), isLocal, props));
    }

    public static ListenerThread getListenerThread(TopicsConfig topicsConfig, boolean isLocal, Properties configuration) {
        return isLocal ? new LocalListenerThread(topicsConfig) : new KafkaListenerThread(KafkaRemoteUtil.getMergedConf(configuration), topicsConfig);
    }

    public static Producer getProducer(boolean isLocal) {
        return isLocal ? new LocalProducer() : new EventProducer();
    }

    public static Properties getMergedConf(Properties configuration) {
        Properties conf = ClientUtils.getConfiguration("consumer.properties");
        conf.putAll((Map<?, ?>)configuration);
        return conf;
    }

    public static KafkaConsumer getConsumer(String topic, Properties properties) {
        KafkaConsumer consumer = new KafkaConsumer(properties);
        List infos = consumer.partitionsFor(topic);
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        if (infos != null) {
            for (PartitionInfo partition : infos) {
                partitions.add(new TopicPartition(topic, partition.partition()));
            }
        }
        consumer.assign(partitions);
        Map offsets = consumer.endOffsets(partitions);
        Long lastOffset = 0L;
        for (Map.Entry entry : offsets.entrySet()) {
            lastOffset = (Long)entry.getValue();
        }
        if (lastOffset == 0L) {
            lastOffset = 1L;
        }
        Set assignments = consumer.assignment();
        for (TopicPartition part : assignments) {
            consumer.seek(part, lastOffset - 1L);
        }
        return consumer;
    }
}

