/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.impl.consumer;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.kie.remote.TopicsConfig;
import org.kie.remote.impl.consumer.ListenerThread;
import org.kie.remote.message.ResultMessage;
import org.kie.remote.util.KafkaRemoteUtil;
import org.kie.remote.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaListenerThread
implements ListenerThread {
    private static Logger logger = LoggerFactory.getLogger(KafkaListenerThread.class);
    private TopicsConfig topicsConfig;
    private Map<String, CompletableFuture<Object>> requestsStore;
    private KafkaConsumer consumer;
    private volatile boolean running = true;

    public KafkaListenerThread(Properties configuration, TopicsConfig config) {
        this.topicsConfig = config;
        this.consumer = KafkaRemoteUtil.getConsumer(this.topicsConfig.getKieSessionInfosTopicName(), configuration);
    }

    @Override
    public void init(Map<String, CompletableFuture<Object>> requestsStore) {
        this.requestsStore = requestsStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.requestsStore == null) {
            throw new IllegalStateException("Request store not initialized, init method must be called before run the thread");
        }
        try {
            while (this.running) {
                ConsumerRecords records = this.consumer.poll(Duration.of(1000L, ChronoUnit.MILLIS));
                for (ConsumerRecord record : records) {
                    Object msg = SerializationUtil.deserialize((byte[])record.value());
                    if (msg instanceof ResultMessage) {
                        this.complete(this.requestsStore, (ResultMessage)msg, logger);
                        continue;
                    }
                    if (msg == null) continue;
                    throw new IllegalStateException("Wrong type of response message: found " + msg.getClass().getCanonicalName() + " instead of " + ResultMessage.class.getCanonicalName());
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.consumer.close();
        }
    }

    public void complete(Map<String, CompletableFuture<Object>> requestsStore, ResultMessage message, Logger logger) {
        CompletableFuture<Object> completableFuture = requestsStore.get(message.getId());
        if (completableFuture != null) {
            completableFuture.complete(message.getResult());
            if (logger.isDebugEnabled()) {
                logger.debug("completed msg with key {}", (Object)message.getId());
            }
        }
    }

    @Override
    public void stop() {
        this.running = false;
    }
}

