/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.runtime.rule.ConsequenceException;
import org.drools.time.SessionPseudoClock;
import org.junit.Test;

public class MiscTest {
    protected KnowledgeBase loadKnowledgeBaseFromString(String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString((KnowledgeBuilderConfiguration)null, (KnowledgeBaseConfiguration)null, drlContentStrings);
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(KnowledgeBuilderConfiguration config, String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString(config, (KnowledgeBaseConfiguration)null, drlContentStrings);
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(KnowledgeBaseConfiguration kBaseConfig, String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString(null, kBaseConfig, drlContentStrings);
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(KnowledgeBuilderConfiguration config, KnowledgeBaseConfiguration kBaseConfig, String ... drlContentStrings) {
        KnowledgeBuilder kbuilder = config == null ? KnowledgeBuilderFactory.newKnowledgeBuilder() : KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)config);
        for (String drlContentString : drlContentStrings) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drlContentString.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            TestCase.fail((String)kbuilder.getErrors().toString());
        }
        if (kBaseConfig == null) {
            kBaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kBaseConfig);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Test
    public void testNullValueInFrom() {
        String str = "global java.util.List list\n\nrule R\nwhen\n    $i : Integer( ) from list\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList<Integer> list = new ArrayList<Integer>();
        ksession.setGlobal("list", list);
        list.add(1);
        list.add(null);
        list.add(2);
        ksession.fireAllRules();
    }

    @Test
    public void testErrorReporting() {
        String str = "global java.util.List list\n\nrule R\nwhen\n    $i : Intege( ) from list\nthen\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kbuilder.hasErrors());
        Assert.assertTrue((boolean)kbuilder.getErrors().toString().contains("Intege"));
    }

    @Test
    public void testUsingSessionClock() {
        String str = "global java.util.List list\n\nrule R\nwhen\n    $i : Integer( ) from list\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        KnowledgeSessionConfiguration ksconfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconfig.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(ksconfig, null);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
    }

    @Test
    public void testUsingNullConfiguration() {
        String str = "global java.util.List list\n\nrule R\nwhen\n    $i : Integer( ) from list\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(null, null);
    }

    @Test
    public void testConsequenceException() {
        String str = "package foo.bar\nrule R\nwhen\nthen\n    throw new RuntimeException(\"foo\");end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        try {
            ksession.fireAllRules();
        }
        catch (ConsequenceException e) {
        }
        catch (Exception other) {
            TestCase.fail((String)("Wrong exception raised = " + other.getClass().getCanonicalName()));
        }
    }
}

