/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.model.Person;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.runtime.rule.ConsequenceException;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.QueryResultsRow;
import org.drools.runtime.rule.Variable;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.time.SessionPseudoClock;
import org.junit.Assert;
import org.junit.Test;

public class MiscTest {
    protected KnowledgeBase loadKnowledgeBaseFromString(String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString((KnowledgeBuilderConfiguration)null, (KnowledgeBaseConfiguration)null, drlContentStrings);
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(KnowledgeBuilderConfiguration config, String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString(config, (KnowledgeBaseConfiguration)null, drlContentStrings);
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(KnowledgeBaseConfiguration kBaseConfig, String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString(null, kBaseConfig, drlContentStrings);
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(KnowledgeBuilderConfiguration config, KnowledgeBaseConfiguration kBaseConfig, String ... drlContentStrings) {
        KnowledgeBuilder kbuilder = config == null ? KnowledgeBuilderFactory.newKnowledgeBuilder() : KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)config);
        for (String drlContentString : drlContentStrings) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drlContentString.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            TestCase.fail((String)kbuilder.getErrors().toString());
        }
        if (kBaseConfig == null) {
            kBaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kBaseConfig);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Test
    public void testNullValueInFrom() {
        String str = "global java.util.List list\n\nrule R\nwhen\n    $i : Integer( ) from list\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList<Integer> list = new ArrayList<Integer>();
        ksession.setGlobal("list", list);
        list.add(1);
        list.add(null);
        list.add(2);
        ksession.fireAllRules();
    }

    @Test
    public void testErrorReporting() {
        String str = "global java.util.List list\n\nrule R\nwhen\n    $i : Intege( ) from list\nthen\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        junit.framework.Assert.assertTrue((boolean)kbuilder.hasErrors());
        junit.framework.Assert.assertTrue((boolean)kbuilder.getErrors().toString().contains("Intege"));
    }

    @Test
    public void testUsingSessionClock() {
        String str = "global java.util.List list\n\nrule R\nwhen\n    $i : Integer( ) from list\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        KnowledgeSessionConfiguration ksconfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconfig.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(ksconfig, null);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
    }

    @Test
    public void testUsingNullConfiguration() {
        String str = "global java.util.List list\n\nrule R\nwhen\n    $i : Integer( ) from list\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(null, null);
    }

    @Test
    public void testConsequenceException() {
        String str = "package foo.bar\nrule R\nwhen\nthen\n    throw new RuntimeException(\"foo\");end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        try {
            ksession.fireAllRules();
        }
        catch (ConsequenceException e) {
        }
        catch (Exception other) {
            TestCase.fail((String)("Wrong exception raised = " + other.getClass().getCanonicalName()));
        }
    }

    @Test
    public void testNotExistingEntryPoint() {
        String str = "package foo.bar\nrule R\nwhen\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        WorkingMemoryEntryPoint entryPoint = ksession.getWorkingMemoryEntryPoint("x");
        junit.framework.Assert.assertNull((Object)entryPoint);
    }

    @Test
    public void testQueriesWithVariableUnification() throws Exception {
        String str = "";
        str = str + "package org.drools.compiler.test  \n";
        str = str + "import org.drools.model.Person \n";
        str = str + "query peeps( String $name, String $likes, int $age ) \n";
        str = str + "    $p : Person( $name := name, $likes := likes, $age := age ) \n";
        str = str + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 300);
        Person p3 = new Person("luke", "brie", 300);
        Person p4 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        QueryResults results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, Variable.v});
        Assert.assertEquals((long)4L, (long)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)4L, (long)names.size());
        junit.framework.Assert.assertTrue((boolean)names.contains("luke"));
        junit.framework.Assert.assertTrue((boolean)names.contains("yoda"));
        junit.framework.Assert.assertTrue((boolean)names.contains("bobba"));
        junit.framework.Assert.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, 300});
        Assert.assertEquals((long)3L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)3L, (long)names.size());
        junit.framework.Assert.assertTrue((boolean)names.contains("luke"));
        junit.framework.Assert.assertTrue((boolean)names.contains("yoda"));
        junit.framework.Assert.assertTrue((boolean)names.contains("bobba"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, "stilton", 300});
        Assert.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)1L, (long)names.size());
        junit.framework.Assert.assertTrue((boolean)names.contains("yoda"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, "stilton", Variable.v});
        Assert.assertEquals((long)2L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)2L, (long)names.size());
        junit.framework.Assert.assertTrue((boolean)names.contains("yoda"));
        junit.framework.Assert.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{"darth", Variable.v, Variable.v});
        Assert.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)1L, (long)names.size());
        junit.framework.Assert.assertTrue((boolean)names.contains("darth"));
    }
}

