/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.task.views;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.SystemEventListenerFactory;
import org.drools.eclipse.task.Activator;
import org.drools.eclipse.task.views.BlockingTaskOperationResponseHandler;
import org.drools.eclipse.task.views.BlockingTaskSummaryResponseHandler;
import org.drools.eclipse.task.views.NewTaskDialog;
import org.drools.eclipse.task.views.TimeoutException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.jbpm.process.workitem.wsht.BlockingAddTaskResponseHandler;
import org.jbpm.task.Status;
import org.jbpm.task.User;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.mina.BaseMinaHandler;
import org.jbpm.task.service.mina.MinaTaskClientConnector;
import org.jbpm.task.service.mina.MinaTaskClientHandler;

public class TaskView
extends ViewPart {
    private static final String NAME_COLUMN = "Name";
    private static final String STATUS_COLUMN = "Status";
    private static final String OWNER_COLUMN = "Owner";
    private static final String CREATED_COLUMN = "Created";
    private static final String COMMENT_COLUMN = "Comment";
    private static String[] columnNames = new String[]{"Name", "Status", "Owner", "Created", "Comment"};
    private static Map<Status, String> STATUSSES = new HashMap<Status, String>();
    private String ipAddress = "127.0.0.1";
    private int port = 9123;
    private String language = "en-UK";
    private Text userNameText;
    private Table table;
    private TableViewer tableViewer;
    private Action refreshAction;
    private Button claimButton;
    private Button startButton;
    private Button stopButton;
    private Button releaseButton;
    private Button suspendButton;
    private Button resumeButton;
    private Button skipButton;
    private Button completeButton;
    private Button failButton;
    private TaskClient client;

    static {
        STATUSSES.put(Status.Created, CREATED_COLUMN);
        STATUSSES.put(Status.Completed, "Completed");
        STATUSSES.put(Status.Error, "Error");
        STATUSSES.put(Status.Exited, "Exited");
        STATUSSES.put(Status.Failed, "Failed");
        STATUSSES.put(Status.InProgress, "InProgress");
        STATUSSES.put(Status.Obsolete, "Obsolete");
        STATUSSES.put(Status.Ready, "Ready");
        STATUSSES.put(Status.Reserved, "Reserved");
        STATUSSES.put(Status.Suspended, "Suspended");
    }

    public TaskView() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.ipAddress = preferenceStore.getString("ServerIPAddress");
        this.port = preferenceStore.getInt("ServerPort");
        this.language = preferenceStore.getString("Language");
        preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("ServerIPAddress".equals(event.getProperty())) {
                    TaskView.this.ipAddress = (String)event.getNewValue();
                } else if ("ServerPort".equals(event.getProperty())) {
                    TaskView.this.port = (Integer)event.getNewValue();
                } else if ("Language".equals(event.getProperty())) {
                    TaskView.this.language = (String)event.getNewValue();
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(11, false));
        Label userNameLabel = new Label(parent, 0);
        userNameLabel.setText("UserId");
        this.userNameText = new Text(parent, 0);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 8;
        layoutData.minimumWidth = 120;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 768;
        this.userNameText.setLayoutData((Object)layoutData);
        Button refresh = new Button(parent, 0x1000008);
        refresh.setText("Refresh");
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.refresh();
            }
        });
        Button create = new Button(parent, 0x1000008);
        create.setText("Create");
        create.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.createTask();
            }
        });
        this.createTable(parent);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.tableViewer.setInput((Object)this.getViewSite());
        this.createButtons(parent);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 11;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText(NAME_COLUMN);
        column.setWidth(300);
        column = new TableColumn(this.table, 16384, 1);
        column.setText(STATUS_COLUMN);
        column.setWidth(100);
        column = new TableColumn(this.table, 16384, 2);
        column.setText(OWNER_COLUMN);
        column.setWidth(100);
        column = new TableColumn(this.table, 0x1000000, 3);
        column.setText(COMMENT_COLUMN);
        column.setWidth(120);
        column = new TableColumn(this.table, 0x1000000, 3);
        column.setText("Created On");
        column.setWidth(120);
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columnNames);
    }

    private void createButtons(Composite parent) {
        this.claimButton = new Button(parent, 0x1000008);
        this.claimButton.setText("Claim");
        this.claimButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.claim();
            }
        });
        this.claimButton.setEnabled(false);
        this.startButton = new Button(parent, 0x1000008);
        this.startButton.setText("Start");
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.start();
            }
        });
        this.startButton.setEnabled(false);
        this.stopButton = new Button(parent, 0x1000008);
        this.stopButton.setText("Stop");
        this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.stop();
            }
        });
        this.stopButton.setEnabled(false);
        this.releaseButton = new Button(parent, 0x1000008);
        this.releaseButton.setText("Release");
        this.releaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.release();
            }
        });
        this.releaseButton.setEnabled(false);
        this.suspendButton = new Button(parent, 0x1000008);
        this.suspendButton.setText("Suspend");
        this.suspendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.suspend();
            }
        });
        this.suspendButton.setEnabled(false);
        this.resumeButton = new Button(parent, 0x1000008);
        this.resumeButton.setText("Resume");
        this.resumeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.resume();
            }
        });
        this.resumeButton.setEnabled(false);
        this.skipButton = new Button(parent, 0x1000008);
        this.skipButton.setText("Skip");
        this.skipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.skip();
            }
        });
        this.skipButton.setEnabled(false);
        this.completeButton = new Button(parent, 0x1000008);
        this.completeButton.setText("Complete");
        this.completeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.complete();
            }
        });
        this.completeButton.setEnabled(false);
        this.failButton = new Button(parent, 0x1000008);
        this.failButton.setText("Fail");
        this.failButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.fail();
            }
        });
        this.failButton.setEnabled(false);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.horizontalAlignment = 1;
        this.failButton.setLayoutData((Object)layoutData);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                System.out.println(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.updateButtons();
            }
        });
    }

    private void updateButtons() {
        boolean selected = this.table.getSelectionCount() == 1;
        TaskSummary task = this.getSelectedTask();
        String userId = this.getUserId();
        this.claimButton.setEnabled(selected && Status.Ready.equals((Object)task.getStatus()));
        this.startButton.setEnabled(selected && (Status.Ready.equals((Object)task.getStatus()) || Status.Reserved.equals((Object)task.getStatus()) && userId.equals(task.getActualOwner().getId())));
        this.stopButton.setEnabled(selected && Status.InProgress.equals((Object)task.getStatus()) && userId.equals(task.getActualOwner().getId()));
        this.releaseButton.setEnabled(selected && (Status.Reserved.equals((Object)task.getStatus()) || Status.InProgress.equals((Object)task.getStatus())) && userId.equals(task.getActualOwner().getId()));
        this.suspendButton.setEnabled(selected && (Status.Ready.equals((Object)task.getStatus()) || (Status.Reserved.equals((Object)task.getStatus()) || Status.InProgress.equals((Object)task.getStatus())) && userId.equals(task.getActualOwner().getId())));
        this.resumeButton.setEnabled(selected && Status.Suspended.equals((Object)task.getStatus()));
        this.skipButton.setEnabled(selected && task.isSkipable() && (Status.Created.equals((Object)task.getStatus()) && Status.Ready.equals((Object)task.getStatus()) || (Status.Reserved.equals((Object)task.getStatus()) || Status.InProgress.equals((Object)task.getStatus())) && userId.equals(task.getActualOwner().getId())));
        this.completeButton.setEnabled(selected && Status.InProgress.equals((Object)task.getStatus()) && userId.equals(task.getActualOwner().getId()));
        this.failButton.setEnabled(selected && Status.InProgress.equals((Object)task.getStatus()) && userId.equals(task.getActualOwner().getId()));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                TaskView.this.refresh();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh the task list");
        this.refreshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.tableViewer.getControl().getShell(), (String)"Task View", (String)message);
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    private void refresh() {
        String userId = this.getUserId();
        if (userId == null) {
            return;
        }
        TaskClient client = this.getTaskClient();
        if (client == null) {
            return;
        }
        try {
            BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
            client.getTasksAssignedAsPotentialOwner(userId, this.language, (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
            List<TaskSummary> tasks = responseHandler.getResults();
            this.tableViewer.setInput(tasks);
            this.tableViewer.refresh();
            this.tableViewer.setSelection(null);
            this.updateButtons();
        }
        catch (TimeoutException timeoutException) {
            this.showMessage("Could not connect to task server, refresh first.");
            try {
                client.disconnect();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            this.client = null;
            this.tableViewer.setInput(new ArrayList());
            this.tableViewer.refresh();
            this.tableViewer.setSelection(null);
        }
    }

    private void createTask() {
        NewTaskDialog dialog = new NewTaskDialog(this.getSite().getShell());
        int result = dialog.open();
        if (result == 0) {
            TaskClient client = this.getTaskClient();
            if (client == null) {
                return;
            }
            BlockingAddTaskResponseHandler responseHandler = new BlockingAddTaskResponseHandler();
            client.addTask(dialog.getTask(), dialog.getContent(), (TaskClientHandler.AddTaskResponseHandler)responseHandler);
            responseHandler.waitTillDone(5000L);
            this.refresh();
        }
    }

    public void claim() {
        TaskClient client = this.getTaskClient();
        if (client == null) {
            return;
        }
        String userId = this.getUserId();
        if (userId == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskSummary.getId(), userId, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void start() {
        TaskClient client = this.getTaskClient();
        if (client == null) {
            return;
        }
        String userId = this.getUserId();
        if (userId == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskSummary.getId(), userId, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void stop() {
        TaskClient client = this.getTaskClient();
        if (client == null) {
            return;
        }
        String userId = this.getUserId();
        if (userId == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.stop(taskSummary.getId(), userId, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void release() {
        TaskClient client = this.getTaskClient();
        if (client == null) {
            return;
        }
        String userId = this.getUserId();
        if (userId == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.release(taskSummary.getId(), userId, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void suspend() {
        TaskClient client = this.getTaskClient();
        if (client == null) {
            return;
        }
        String userId = this.getUserId();
        if (userId == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.suspend(taskSummary.getId(), userId, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void resume() {
        TaskClient client = this.getTaskClient();
        if (client == null) {
            return;
        }
        String userId = this.getUserId();
        if (userId == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.resume(taskSummary.getId(), userId, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void skip() {
        TaskClient client = this.getTaskClient();
        if (client == null) {
            return;
        }
        String userId = this.getUserId();
        if (userId == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.skip(taskSummary.getId(), userId, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void complete() {
        TaskClient client = this.getTaskClient();
        if (client == null) {
            return;
        }
        String userId = this.getUserId();
        if (userId == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.complete(taskSummary.getId(), userId, null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(3000L);
        this.refresh();
    }

    public void fail() {
        TaskClient client = this.getTaskClient();
        if (client == null) {
            return;
        }
        String userId = this.getUserId();
        if (userId == null) {
            return;
        }
        TaskSummary taskSummary = this.getSelectedTask();
        if (taskSummary == null) {
            return;
        }
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.fail(taskSummary.getId(), userId, null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(3000L);
        this.refresh();
    }

    private TaskClient getTaskClient() {
        if (this.client == null) {
            this.client = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("client 1", (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
            boolean connected = this.client.connect(this.ipAddress, this.port);
            if (!connected) {
                this.showMessage("Could not connect to task server: " + this.ipAddress + " [port " + this.port + "]");
                this.client = null;
            }
        }
        return this.client;
    }

    public void dispose() {
        if (this.client != null) {
            try {
                this.client.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.dispose();
    }

    private String getUserId() {
        return this.userNameText.getText();
    }

    private TaskSummary getSelectedTask() {
        Object selected;
        ISelection selection = this.tableViewer.getSelection();
        if (selection instanceof StructuredSelection && (selected = ((StructuredSelection)selection).getFirstElement()) instanceof TaskSummary) {
            return (TaskSummary)selected;
        }
        return null;
    }

    private class ViewContentProvider
    implements IStructuredContentProvider {
        private ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof List) {
                List tasks = (List)parent;
                return tasks.toArray();
            }
            return new String[0];
        }
    }

    private class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof TaskSummary) {
                TaskSummary taskSummary = (TaskSummary)obj;
                switch (index) {
                    case 0: {
                        return taskSummary.getName();
                    }
                    case 1: {
                        Status status = taskSummary.getStatus();
                        return status == null ? null : (String)STATUSSES.get(status);
                    }
                    case 2: {
                        User user = taskSummary.getActualOwner();
                        if (user == null) {
                            return null;
                        }
                        return user.getId();
                    }
                    case 3: {
                        return DateFormat.getDateTimeInstance().format(taskSummary.getCreatedOn());
                    }
                    case 4: {
                        return taskSummary.getDescription();
                    }
                }
                throw new IllegalArgumentException("Unknown column index: " + index);
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

