/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseFactory;
import org.drools.core.StatefulSession;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.spi.Activation;
import org.drools.core.spi.AgendaGroup;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.rule.Match;

public class DebugViewsTest {
    @Test
    public void testApplicationDataView() throws Exception {
        InputStreamReader source = new InputStreamReader(DebugViewsTest.class.getResourceAsStream("/debug.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)source);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("s", (Object)"String");
        ArrayList<String> list = new ArrayList<String>();
        list.add("Value");
        session.setGlobal("list", list);
        Map.Entry[] globals = ((MapGlobalResolver)session.getGlobalResolver()).getGlobals();
        Assert.assertEquals((long)2L, (long)globals.length);
        if ("list".equals(globals[0].getKey())) {
            Assert.assertEquals((Object)"list", globals[0].getKey());
            Assert.assertEquals(list, globals[0].getValue());
            Assert.assertEquals((Object)"s", globals[1].getKey());
            Assert.assertEquals((Object)"String", globals[1].getValue());
        } else {
            Assert.assertEquals((Object)"list", globals[1].getKey());
            Assert.assertEquals(list, globals[1].getValue());
            Assert.assertEquals((Object)"s", globals[0].getKey());
            Assert.assertEquals((Object)"String", globals[0].getValue());
        }
    }

    @Test
    @Ignore
    public void testAgendaView() throws Exception {
        InputStreamReader source = new InputStreamReader(DebugViewsTest.class.getResourceAsStream("/debug.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)source);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        AbstractWorkingMemory session = (AbstractWorkingMemory)ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.insert((Object)"String1");
        String focusName = session.getAgenda().getFocusName();
        Assert.assertEquals((Object)"MAIN", (Object)focusName);
        AgendaGroup[] agendaGroups = session.getAgenda().getAgendaGroups();
        Assert.assertEquals((long)1L, (long)agendaGroups.length);
        Assert.assertEquals((Object)"MAIN", (Object)agendaGroups[0].getName());
        Assert.assertEquals((long)1L, (long)agendaGroups[0].getActivations().length);
        Match activation = agendaGroups[0].getActivations()[0];
        Assert.assertEquals((Object)"ActivationCreator", (Object)activation.getRule().getName());
        Map.Entry[] parameters = session.getActivationParameters(((Activation)activation).getActivationNumber());
        Assert.assertEquals((long)1L, (long)parameters.length);
        Assert.assertEquals((Object)"o", parameters[0].getKey());
        Assert.assertEquals((Object)"String1", parameters[0].getValue());
    }

    @Test
    public void testWorkingMemoryView() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        AbstractWorkingMemory session = (AbstractWorkingMemory)ruleBase.newStatefulSession();
        session.insert((Object)"Test1");
        session.insert((Object)"Test2");
        Object[] objects = session.iterateObjectsToList().toArray();
        Assert.assertEquals((long)2L, (long)objects.length);
        Assert.assertTrue(("Test1".equals(objects[0]) && "Test2".equals(objects[1]) || "Test2".equals(objects[0]) && "Test1".equals(objects[1]) ? 1 : 0) != 0);
    }
}

