/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.PackageIntegrationException;
import org.drools.core.RuleBaseFactory;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.rule.Package;
import org.drools.eclipse.editors.rete.ReteooLayoutFactory;
import org.drools.eclipse.editors.rete.Row;
import org.drools.eclipse.editors.rete.RowList;
import org.drools.eclipse.editors.rete.model.ReteGraph;
import org.drools.eclipse.reteoo.AlphaNodeVertex;
import org.drools.eclipse.reteoo.BaseVertex;
import org.drools.eclipse.reteoo.EntryPointNodeVertex;
import org.drools.eclipse.reteoo.LeftInputAdapterNodeVertex;
import org.drools.eclipse.reteoo.ObjectTypeNodeVertex;
import org.drools.eclipse.reteoo.ReteVertex;
import org.drools.eclipse.reteoo.ReteooVisitor;
import org.drools.eclipse.reteoo.RuleTerminalNodeVertex;
import org.junit.Assert;
import org.junit.Test;

public class ReteooLayoutFactoryTest {
    @Test
    public void testCalculateReteRows() throws IOException, PackageIntegrationException, DroolsParserException {
        ReteGraph graph = new ReteGraph();
        BaseVertex root = this.loadRete(graph);
        RowList rows = ReteooLayoutFactory.calculateReteRows((BaseVertex)root);
        int rownum = rows.getDepth();
        Assert.assertEquals((long)6L, (long)rownum);
        int[] nArray = new int[6];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        int[] expectedDepths = nArray;
        int[] expectedSizes = new int[]{1, 1, 1, 2, 2, 2};
        int j = 0;
        while (j < rownum) {
            Row row = rows.get(j);
            int rowDepth = row.getDepth();
            Assert.assertEquals((long)expectedDepths[j], (long)rowDepth);
            Assert.assertEquals((long)expectedSizes[j], (long)row.getVertices().size());
            ++j;
        }
    }

    @Test
    public void testLayoutRowList() throws IOException, PackageIntegrationException, DroolsParserException {
        ReteGraph graph = new ReteGraph();
        BaseVertex root = this.loadRete(graph);
        RowList rows = ReteooLayoutFactory.calculateReteRows((BaseVertex)root);
        ReteooLayoutFactory.layoutRowList((ReteGraph)graph, (RowList)rows);
        List nodes = graph.getChildren();
        BaseVertex[] yOrder = nodes.toArray(new BaseVertex[0]);
        Arrays.sort(yOrder, new Comparator(){

            public int compare(Object o1, Object o2) {
                BaseVertex v1 = (BaseVertex)o1;
                BaseVertex v2 = (BaseVertex)o2;
                int y1 = v1.getLocation().y;
                int y2 = v2.getLocation().y;
                return new Integer(y1).compareTo(new Integer(y2));
            }
        });
        Class[] expectedTypes = new Class[]{ReteVertex.class, EntryPointNodeVertex.class, ObjectTypeNodeVertex.class, AlphaNodeVertex.class, AlphaNodeVertex.class, LeftInputAdapterNodeVertex.class, LeftInputAdapterNodeVertex.class, RuleTerminalNodeVertex.class, RuleTerminalNodeVertex.class};
        int i = 0;
        while (i < yOrder.length) {
            Assert.assertEquals((Object)expectedTypes[i], yOrder[i].getClass());
            if (i > 0) {
                BaseVertex current = yOrder[i];
                BaseVertex previous = yOrder[i - 1];
                if (current.getClass().equals(previous.getClass())) {
                    Assert.assertEquals((long)current.getLocation().y, (long)previous.getLocation().y);
                    Assert.assertNotSame((Object)new Integer(current.getLocation().x), (Object)new Integer(previous.getLocation().x));
                } else {
                    Assert.assertNotSame((Object)new Integer(current.getLocation().y), (Object)new Integer(previous.getLocation().y));
                }
            }
            ++i;
        }
    }

    private BaseVertex loadRete(ReteGraph graph) throws IOException, PackageIntegrationException, DroolsParserException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("simplerule.drl");
        String drl = this.streamToString(is);
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(null, drl);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase((int)1);
        ruleBase.addPackage(pkg);
        ReteooVisitor visitor = new ReteooVisitor(graph);
        visitor.visit((Object)ruleBase);
        BaseVertex root = visitor.getRootVertex();
        return root;
    }

    private String streamToString(InputStream is) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((read = is.read(buffer)) != -1) {
            ((OutputStream)outputStream).write(buffer, 0, read);
        }
        ((OutputStream)outputStream).close();
        is.close();
        return ((Object)outputStream).toString();
    }

    public static class Message {
        public static final int HELLO = 0;
        public static final int GOODBYE = 1;
        private String message;
        private int status;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }
    }
}

