/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import org.drools.eclipse.editors.completion.CompletionUtil;
import org.junit.Assert;
import org.junit.Test;

public class CompletionUtilTest {
    @Test
    public void testIsGetter() {
        Assert.assertTrue((boolean)CompletionUtil.isGetter((String)"getThis", (int)0, (String)"String"));
    }

    @Test
    public void testIsGetterCannotReturnVoid() {
        Assert.assertFalse((boolean)CompletionUtil.isGetter((String)"getThis", (int)0, (String)"V"));
    }

    @Test
    public void testIsGetterWrongPrefix() {
        Assert.assertFalse((boolean)CompletionUtil.isGetter((String)"hasThis", (int)0, (String)"V"));
    }

    @Test
    public void testIsGetterTooManyArgs() {
        Assert.assertFalse((boolean)CompletionUtil.isGetter((String)"getThis", (int)2, (String)"String"));
    }

    @Test
    public void testIsGetterMethodNameTooShort() {
        Assert.assertFalse((boolean)CompletionUtil.isGetter((String)"get", (int)2, (String)"String"));
    }

    @Test
    public void testIsIsGetter() {
        Assert.assertTrue((boolean)CompletionUtil.isIsGetter((String)"isGood", (int)0, (String)"Z"));
    }

    @Test
    public void testIsIsGetterWrongPrefix() {
        Assert.assertFalse((boolean)CompletionUtil.isIsGetter((String)"getThis", (int)0, (String)"Z"));
    }

    @Test
    public void testIsIsGetterAlwaysReturnsBoolean() {
        Assert.assertFalse((boolean)CompletionUtil.isIsGetter((String)"isThis", (int)0, (String)"V"));
    }

    @Test
    public void testIsIsGetterTooManyArgs() {
        Assert.assertFalse((boolean)CompletionUtil.isIsGetter((String)"isThis", (int)2, (String)"String"));
    }

    @Test
    public void testIsIsGetterMethodNameTooShort() {
        Assert.assertFalse((boolean)CompletionUtil.isIsGetter((String)"is", (int)2, (String)"String"));
    }

    @Test
    public void testIsSetter() {
        Assert.assertTrue((boolean)CompletionUtil.isSetter((String)"setThat", (int)1, (String)"V"));
    }

    @Test
    public void testIsSetterWrongPrefix() {
        Assert.assertFalse((boolean)CompletionUtil.isSetter((String)"getThat", (int)1, (String)"V"));
    }

    @Test
    public void testIsSetterTooShort() {
        Assert.assertFalse((boolean)CompletionUtil.isSetter((String)"se", (int)1, (String)"V"));
    }

    @Test
    public void testIsSetterNoArgs() {
        Assert.assertFalse((boolean)CompletionUtil.isSetter((String)"setThat", (int)0, (String)"V"));
    }

    @Test
    public void testIsSetterWrongType() {
        Assert.assertFalse((boolean)CompletionUtil.isSetter((String)"setThat", (int)1, (String)"String"));
    }

    @Test
    public void testGetPropertyName() {
        Assert.assertEquals((Object)"me", (Object)CompletionUtil.getPropertyName((String)"getMe", (int)0, (String)"String"));
        Assert.assertEquals((Object)"me", (Object)CompletionUtil.getPropertyName((String)"isMe", (int)0, (String)"Z"));
        Assert.assertEquals((Object)"me", (Object)CompletionUtil.getPropertyName((String)"setMe", (int)1, (String)"V"));
        Assert.assertEquals((Object)"setMe", (Object)CompletionUtil.getPropertyName((String)"setMe", (int)0, (String)"V"));
        Assert.assertEquals((Object)"MySuperMethod", (Object)CompletionUtil.getPropertyName((String)"MySuperMethod", (int)1, (String)"V"));
    }

    @Test
    public void testGetPropertyNameStripsParenthesis() {
        Assert.assertEquals((Object)"MySuperMethod()", (Object)CompletionUtil.getPropertyName((String)"MySuperMethod()", (int)1, (String)"V"));
        Assert.assertEquals((Object)"me", (Object)CompletionUtil.getPropertyName((String)"getMe()", (int)0, (String)"String"));
        Assert.assertEquals((Object)"me", (Object)CompletionUtil.getPropertyName((String)"isMe()", (int)0, (String)"Z"));
        Assert.assertEquals((Object)"me", (Object)CompletionUtil.getPropertyName((String)"setMe()", (int)1, (String)"V"));
    }

    @Test
    public void testStripLastWord() {
        String backtext = "rule \"GoodBye\"\r\n    no-loop true\r\n    when\r\n        m : Message( status == Message.GOODBYE, message : message )\r\n    then\r\n        m.message=message;\r\n        m.last";
        String lastword = "last";
        Assert.assertEquals((Object)lastword, (Object)CompletionUtil.stripLastWord((String)backtext));
    }

    @Test
    public void testGetPreviousExpression1() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   adasd ='d';";
        String previous = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   adasd ='d';";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getPreviousExpression((String)backText));
    }

    @Test
    public void testGetPreviousExpression2() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   message== ";
        String previous = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getPreviousExpression((String)backText));
    }

    @Test
    public void testGetPreviousExpression3() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   message(sdasdasd, ";
        String previous = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getPreviousExpression((String)backText));
    }

    @Test
    public void testGetPreviousExpression4() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   message( ";
        String previous = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getPreviousExpression((String)backText));
    }

    @Test
    public void testGetPreviousExpression5() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   this.asd ";
        String previous = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getPreviousExpression((String)backText));
    }

    @Test
    public void testGetPreviousExpression6() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   message(){ ";
        String previous = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getPreviousExpression((String)backText));
    }

    @Test
    public void testGetPreviousExpression7() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   adasd ='d';message== ";
        String previous = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   adasd ='d';";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getPreviousExpression((String)backText));
    }

    @Test
    public void testGetLastExpression11() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   adasd ='d'";
        String previous = "\r\n   adasd ='d'";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetLastExpression1() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   adasd ='d';";
        String previous = "\r\n   adasd ='d'";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetLastExpression10() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   adasd ='d';\r\n";
        Assert.assertEquals((Object)backText, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetLastExpression2() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   message== ";
        String previous = "\r\n   message== ";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetLastExpression3() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   message(sdasdasd, ";
        String previous = "\r\n   message(sdasdasd, ";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetLastExpression4() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   message( ";
        String previous = "\r\n   message( ";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetLastExpression5() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   this.asd ";
        String previous = "\r\n   this.asd ";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetLastExpression6() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   message(){ ";
        String previous = "\r\n   message(){ ";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetLastExpression7() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   adasd ='d';message== ";
        String previous = "message== ";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetInnerExpression() {
        String backText = "  \r\n   System.out.println( message );\r\n   m.message = \"Goodbyte cruel world\";\r\n   m.status = 1;\r\n   adasd ='d';message== ";
        String previous = "";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getInnerExpression((String)backText));
    }

    @Test
    public void testGetInnerExpression2() {
        String backText = "System.out.println(m ";
        String previous = "m";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getInnerExpression((String)backText));
    }

    @Test
    public void testGetInnerExpression3() {
        String backText = "update(m) {";
        String previous = "";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getInnerExpression((String)backText));
    }

    @Test
    public void testGetInnerExpression4() {
        String backText = "update(m) {some=";
        String previous = "";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getInnerExpression((String)backText));
    }

    @Test
    public void testGetInnerExpression5() {
        String backText = "update(m) {asdasdas==asdasd, asdasd";
        String previous = "asdasd";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getInnerExpression((String)backText));
    }

    @Test
    public void testGetInnerExpression6() {
        String backText = "update(m) {asdasdas==asdasd, asdasd}";
        String previous = "";
        Assert.assertEquals((Object)previous, (Object)CompletionUtil.getInnerExpression((String)backText));
    }

    @Test
    public void testGetLastExpression_withComments() {
        String backText = "dasdasdas\nsasasasa\n //fsdfsdfdsfdsf\n\n";
        String exp = "dasdasdas\nsasasasa\n //fsdfsdfdsfdsf\n\n";
        Assert.assertEquals((Object)exp, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetLastExpression_withComments2() {
        String backText = "dasdasdas\nsasasasa\n //fsdfsdfdsfdsf\n";
        String exp = "dasdasdas\nsasasasa\n //fsdfsdfdsfdsf\n";
        Assert.assertEquals((Object)exp, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetLastExpression_withComments3() {
        String backText = "dasdasdas\nsasasasa\n //fsdfsdfdsfdsf\n";
        String exp = "dasdasdas\nsasasasa\n //fsdfsdfdsfdsf\n";
        Assert.assertEquals((Object)exp, (Object)CompletionUtil.getLastExpression((String)backText));
    }

    @Test
    public void testGetTextWithoutPrefix() {
        String text = "modify(m) {asdasdas==asdasd, asdasd.asa";
        String expected = "modify(m) {asdasdas==asdasd, asdasd.";
        Assert.assertEquals((Object)expected, (Object)CompletionUtil.getTextWithoutPrefix((String)text, (String)"asa"));
    }

    @Test
    public void testGetTextWithoutPrefix2() {
        String text = "it";
        String expected = "";
        Assert.assertEquals((Object)expected, (Object)CompletionUtil.getTextWithoutPrefix((String)text, (String)text));
    }
}

