/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.drools.eclipse.editors.DRLRuleEditor2;
import org.drools.eclipse.editors.ZoomInAction2;
import org.drools.eclipse.editors.ZoomOutAction2;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ZoomControlTest {
    private IFile fFile1;
    private IFile fFile2;
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private static final String ORIGINAL_CONTENT = "package test\nrule \"a\"\nend\nrule \"b\"\nend";

    private String getOriginalContent() {
        return ORIGINAL_CONTENT;
    }

    @Before
    public void setUp() throws Exception {
        IFolder folder = this.createFolder("ZoomControlTestProject/multipleEditorTest/");
        this.fFile1 = this.createFile(folder, "myfile1.drl", this.getOriginalContent());
        this.fFile2 = this.createFile(folder, "myfile2.drl", this.getOriginalContent());
    }

    @After
    public void tearDown() throws Exception {
        this.deleteProject("ZoomControlTestProject");
        this.fFile1 = null;
        this.fFile2 = null;
    }

    @Test
    @Ignore
    public void testMultipleEditors() throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        DRLRuleEditor2 part1 = (DRLRuleEditor2)IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile1);
        DRLRuleEditor2 part2 = (DRLRuleEditor2)IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile2);
        this.checkVisibility(part1, part2, false);
        page.activate((IWorkbenchPart)part1);
        this.checkVisibility(part1, part2, false);
    }

    @Test
    @Ignore
    public void testSecondEditorAfterFirst() throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        DRLRuleEditor2 cfr_ignored_0 = (DRLRuleEditor2)IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile1);
    }

    private void checkVisibility(DRLRuleEditor2 part1, DRLRuleEditor2 part2, boolean enabled) {
        if (part1 != null) {
            this.checkVisibility(part1, enabled);
        }
        if (part2 != null) {
            this.checkVisibility(part2, enabled);
        }
    }

    private void checkVisibility(DRLRuleEditor2 editor, boolean enabled) {
        ZoomInAction2 zoomIn = (ZoomInAction2)editor.getAdapter(ZoomInAction2.class);
        ZoomOutAction2 zoomOut = (ZoomOutAction2)editor.getAdapter(ZoomOutAction2.class);
        ZoomComboContributionItem zitem = (ZoomComboContributionItem)editor.getAdapter(ZoomComboContributionItem.class);
        Assert.assertEquals((Object)enabled, (Object)zoomIn.isEnabled());
        Assert.assertEquals((Object)enabled, (Object)zoomOut.isEnabled());
        Assert.assertEquals((Object)enabled, (Object)(zitem.getZoomManager() != null ? 1 : 0));
    }

    private IFile createFile(IFolder folder, String name, String contents) throws CoreException {
        IFile file = folder.getFile(name);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes());
        file.create((InputStream)inputStream, true, NULL_MONITOR);
        return file;
    }

    private IFolder createFolder(String portableFolderPath) throws CoreException {
        ContainerCreator creator = new ContainerCreator(ResourcesPlugin.getWorkspace(), (IPath)new Path(portableFolderPath));
        IContainer container = creator.createContainer(NULL_MONITOR);
        return (IFolder)container;
    }

    private void deleteProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            project.delete(true, true, NULL_MONITOR);
        }
    }
}

