/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.rule;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.drools.eclipse.wizard.rule.DRLGenerator;
import org.junit.Assert;
import org.junit.Test;

public class DRLGenTemplateTest {
    @Test
    public void testNewRule() throws Exception {
        DRLGenerator gen = new DRLGenerator();
        InputStream result = gen.generateRule("myPackage", this.getClass().getResourceAsStream("new_rule.drl.template"));
        Assert.assertNotNull((Object)result);
        StringBuffer buf = this.getResult(result);
        Assert.assertTrue((buf.toString().indexOf("package myPackage") > -1 ? 1 : 0) != 0);
        Assert.assertFalse((buf.toString().indexOf("$date$") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testNewPackage() throws Exception {
        DRLGenerator gen = new DRLGenerator();
        InputStream result = gen.generatePackage("myPackage", true, true, this.getClass().getResourceAsStream("new_rule.drl.template"));
        Assert.assertNotNull((Object)result);
        StringBuffer buf = this.getResult(result);
        Assert.assertTrue((buf.toString().indexOf("package myPackage") > -1 ? 1 : 0) != 0);
        Assert.assertFalse((buf.toString().indexOf("$date$") > -1 ? 1 : 0) != 0);
        Assert.assertFalse((buf.toString().indexOf("$expander$") > -1 ? 1 : 0) != 0);
        Assert.assertFalse((buf.toString().indexOf("$functions$") > -1 ? 1 : 0) != 0);
    }

    private StringBuffer getResult(InputStream result) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(result));
        String line = null;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buf.append(String.valueOf(line) + "\n");
        }
        return buf;
    }
}

